/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v1.consultaarea;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceita;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultaarea.WebReceitaInterfaceArea;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultaarea.model.DTOAreaResult;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Response;

@Component
public class WebReceitaArea
extends WebReceita {
    public DTOAreaResult getArea(WebReceitaConfig config, Long idUnidade, Double quantidade, Long aplicacao, Double dose, Double volume) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceArea bookResource = (WebReceitaInterfaceArea)this.getRetrofit(config).create(WebReceitaInterfaceArea.class);
            Call<DTOAreaResult> books = bookResource.consultaArea(idUnidade, quantidade, aplicacao, dose, volume);
            Response res = books.execute();
            DTOAreaResult ret = (DTOAreaResult)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getSucesso() == null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaArea.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

