/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v1.consultarelacao;

import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceita;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultarelacao.WebReceitaInterfaceRelacao;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultarelacao.model.DTOConsultaPragaAlvo;
import com.touchcomp.basementorclientwebservices.webreceita.v1.consultarelacao.model.DTOConsultaRelacaoResult;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.json.ToolJson;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.ResponseBody;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Response;

@Component
public class WebReceitaRelacao
extends WebReceita {
    public DTOConsultaRelacaoResult[] getRelacao(WebReceitaConfig config, Long idProduto, Long idCultura, Long idAlvo, Long idProdutor) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceRelacao bookResource = (WebReceitaInterfaceRelacao)this.getRetrofit(config).create(WebReceitaInterfaceRelacao.class);
            Call<ResponseBody> books = bookResource.consultaRelacao(idProduto, idCultura, idAlvo, idProdutor);
            Response res = books.execute();
            if (res == null || res.body() == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            String ret = ((ResponseBody)res.body()).string();
            if (ret == null || ret.contains("aviso")) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message() + ". Retorno: " + ret});
            }
            return ToolJson.readJsonList((String)ret, DTOConsultaRelacaoResult.class).toArray(new DTOConsultaRelacaoResult[0]);
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaRelacao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public List<DTOConsultaPragaAlvo.DTOPragaAlvo> getRelacao(WebReceitaConfig config, String idCultura, String idProduto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceRelacao bookResource = (WebReceitaInterfaceRelacao)this.getRetrofit(config).create(WebReceitaInterfaceRelacao.class);
            Call<ResponseBody> books = bookResource.consultaRelacao(idCultura, idProduto);
            Response res = books.execute();
            if (res.body() == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            String ret = ((ResponseBody)res.body()).string();
            if (ret == null || ret.contains("aviso")) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message() + ". Retorno: " + ret});
            }
            DTOConsultaPragaAlvo aux = (DTOConsultaPragaAlvo)ToolJson.readJson((String)ret, DTOConsultaPragaAlvo.class);
            return aux != null ? aux.getAlvo() : null;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaRelacao.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

