/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v1.produtorrural;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceita;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtorrural.WebReceitaInterfaceProdutor;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtorrural.model.DTOProdutorRural;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtorrural.model.DTOProdutorRuralResult;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.json.ToolJson;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.ResponseBody;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Response;

@Component
public class WebReceitaProdutor
extends WebReceita {
    public DTOProdutorRuralResult inserirProdutor(WebReceitaConfig config, DTOProdutorRural produtor) throws ExceptionIO, ExceptionValidacaoDados {
        String ret = null;
        try {
            WebReceitaInterfaceProdutor bookResource = (WebReceitaInterfaceProdutor)this.getRetrofit(config).create(WebReceitaInterfaceProdutor.class);
            Call<ResponseBody> books = bookResource.inserirProdutor(produtor);
            Response res = books.execute();
            if (res.body() == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            ret = ((ResponseBody)res.body()).string();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message() + ". Retorno: " + ret});
            }
            try {
                DTOProdutorRuralResult dtoRet = (DTOProdutorRuralResult)ToolJson.readJson((String)ret, DTOProdutorRuralResult.class);
                if (dtoRet.getAviso() != null) {
                    dtoRet.setStatus(EnumConstantsMentorStatus.ERRO);
                } else {
                    dtoRet.setStatus(EnumConstantsMentorStatus.SUCESSO);
                }
                return dtoRet;
            }
            catch (Exception ex) {
                Logger.getLogger(WebReceitaProdutor.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionIO(ex, new Object[]{"Erro ao converter os dados: " + ret});
            }
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaProdutor.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

