/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v1.produtos;

import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceita;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtos.WebReceitaInterfaceProdutos;
import com.touchcomp.basementorclientwebservices.webreceita.v1.produtos.model.DTOProduto;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementortools.tools.json.ToolJson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.ResponseBody;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Response;

@Component
public class WebReceitaProdutos
extends WebReceita {
    public DTOProduto getProdutos(WebReceitaConfig config) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceProdutos resource = (WebReceitaInterfaceProdutos)this.getRetrofit(config).create(WebReceitaInterfaceProdutos.class);
            Call<ResponseBody> books = resource.getProdutos();
            Response res = books.execute();
            if (res == null || res.body() == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            String ret = new String(((ResponseBody)res.body()).bytes(), Charset.forName("ISO-8859-1"));
            if (ret == null || ret.contains("aviso")) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message() + ". Retorno: " + ret});
            }
            return (DTOProduto)ToolJson.readJson((String)ret, DTOProduto.class);
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaProdutos.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

