/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v1.receita;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceita;
import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.WebReceitaInterfaceReceita;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgro;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroEmissao;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroEmissaoResult;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroItem;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroItemResult;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroResult;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroResultDelete;
import com.touchcomp.basementorclientwebservices.webreceita.v1.receita.model.DTOReceitaAgroResultItemDelete;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;
import retrofit2.Call;
import retrofit2.Response;

@Component
public class WebReceitaReceita
extends WebReceita {
    public DTOReceitaAgroResult inserirReceita(WebReceitaConfig config, DTOReceitaAgro receita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceReceita bookResource = (WebReceitaInterfaceReceita)this.getRetrofit(config).create(WebReceitaInterfaceReceita.class);
            Call<DTOReceitaAgroResult> books = bookResource.inserirReceita(receita);
            Response res = books.execute();
            DTOReceitaAgroResult ret = (DTOReceitaAgroResult)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getSucesso() == null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaReceita.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOReceitaAgroEmissaoResult emitirReceita(WebReceitaConfig config, DTOReceitaAgroEmissao receita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceReceita bookResource = (WebReceitaInterfaceReceita)this.getRetrofit(config).create(WebReceitaInterfaceReceita.class);
            Call<DTOReceitaAgroEmissaoResult> books = bookResource.emitirReceita(receita);
            Response res = books.execute();
            DTOReceitaAgroEmissaoResult ret = (DTOReceitaAgroEmissaoResult)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getAviso() != null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaReceita.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOReceitaAgroEmissaoResult consultarReceita(WebReceitaConfig config, String idReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceReceita bookResource = (WebReceitaInterfaceReceita)this.getRetrofit(config).create(WebReceitaInterfaceReceita.class);
            Call<DTOReceitaAgroEmissaoResult> books = bookResource.consultarReceita(idReceita);
            Response res = books.execute();
            DTOReceitaAgroEmissaoResult ret = (DTOReceitaAgroEmissaoResult)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getAviso() != null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaReceita.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOReceitaAgroItemResult inserirItemReceita(WebReceitaConfig config, DTOReceitaAgroItem receitaItem) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceReceita bookResource = (WebReceitaInterfaceReceita)this.getRetrofit(config).create(WebReceitaInterfaceReceita.class);
            Call<DTOReceitaAgroItemResult> books = bookResource.inserirItemReceita(receitaItem);
            Response res = books.execute();
            DTOReceitaAgroItemResult ret = (DTOReceitaAgroItemResult)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getSucesso() == null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaReceita.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOReceitaAgroResultDelete excluirReceita(WebReceitaConfig config, Long idReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceReceita bookResource = (WebReceitaInterfaceReceita)this.getRetrofit(config).create(WebReceitaInterfaceReceita.class);
            Call<DTOReceitaAgroResultDelete> books = bookResource.excluirReceita(idReceita);
            Response res = books.execute();
            DTOReceitaAgroResultDelete ret = (DTOReceitaAgroResultDelete)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getSucesso() == null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaReceita.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOReceitaAgroResultItemDelete excluirItemReceita(WebReceitaConfig config, Long idItemReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            WebReceitaInterfaceReceita bookResource = (WebReceitaInterfaceReceita)this.getRetrofit(config).create(WebReceitaInterfaceReceita.class);
            Call<DTOReceitaAgroResultItemDelete> books = bookResource.excluirItemReceita(idItemReceita);
            Response res = books.execute();
            DTOReceitaAgroResultItemDelete ret = (DTOReceitaAgroResultItemDelete)res.body();
            if (ret == null) {
                throw new ExceptionValidacaoDados("E.ERP.0094.107", new Object[]{res.message()});
            }
            if (ret.getSucesso() == null) {
                ret.setStatus(EnumConstantsMentorStatus.ERRO);
            } else {
                ret.setStatus(EnumConstantsMentorStatus.SUCESSO);
            }
            return ret;
        }
        catch (IOException ex) {
            Logger.getLogger(WebReceitaReceita.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

