/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v2.consultarelacao;

import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v2.WebReceitaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.consultarelacao.model.DTOConsultaRelCulturaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.consultarelacao.model.DTOConsultaRelPragaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.consultarelacao.model.DTOConsultaRelacaoComplexV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.consultarelacao.model.DTOConsultaRelacaoV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.cultura.WebReceitaCulturasV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;

@Component
public class WebReceitaRelacaoV2
extends WebReceitaV2 {
    private final String URL_RELACAO = "https://www.novoreceituarioagronomico.com.br/api/relacoes/complex/?produto_id={0}&cultura_id={1}&problema_id={2}";
    private final String URL_RELACAO_SIMPLE = "https://www.novoreceituarioagronomico.com.br/api/relacoes/simple/?produto_id={0}&cultura_id={1}&problema_id={2}";
    private final String URL_PRAGAS_PRODUTO = "https://www.novoreceituarioagronomico.com.br/api/relacoes/problema/?produto_id={0}&cultura_id={1}";
    private final String URL_CULTURAS_PRODUTO = "https://www.novoreceituarioagronomico.com.br/api/relacoes/cultura/?produto_id={0}";
    private final String URL_FICHA_EMERGENCIA_PRODUTO = "https://www.novoreceituarioagronomico.com.br/api/fichas-emergencia/imprimir/?produto={0}";

    public DTOConsultaRelacaoV2 getRelacao(WebReceitaConfig config, String idProduto, String idCultura, String idAlvo) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String tempUrl = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/relacoes/simple/?produto_id={0}&cultura_id={1}&problema_id={2}", idProduto, idCultura, idAlvo);
            return this.buildAndGetOne(tempUrl, config.getSenha(), DTOConsultaRelacaoV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaCulturasV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOConsultaRelacaoComplexV2 getRelacaoComplex(WebReceitaConfig config, String idProduto, String idCultura, String idAlvo) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String tempUrl = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/relacoes/complex/?produto_id={0}&cultura_id={1}&problema_id={2}", idProduto, idCultura, idAlvo);
            return this.buildAndGetOne(tempUrl, config.getSenha(), DTOConsultaRelacaoComplexV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaCulturasV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOConsultaRelacaoV2 getFichaEmergencia(WebReceitaConfig config, String idProduto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String tempUrl = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/fichas-emergencia/imprimir/?produto={0}", idProduto);
            return this.buildAndGetOne(tempUrl, config.getSenha(), DTOConsultaRelacaoV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaCulturasV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOConsultaRelPragaV2 getPragas(WebReceitaConfig config, String idCultura, String idProduto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String tempUrl = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/relacoes/problema/?produto_id={0}&cultura_id={1}", idProduto, idCultura);
            return this.buildAndGetOne(tempUrl, config.getSenha(), DTOConsultaRelPragaV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaCulturasV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOConsultaRelCulturaV2 getCulturas(WebReceitaConfig config, String idProduto) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String tempUrl = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/relacoes/cultura/?produto_id={0}", idProduto);
            return this.buildAndGetOne(tempUrl, config.getSenha(), DTOConsultaRelCulturaV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaCulturasV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

