/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorclientwebservices.webreceita.v2.receita;

import com.touchcomp.basementorclientwebservices.webreceita.v1.WebReceitaConfig;
import com.touchcomp.basementorclientwebservices.webreceita.v2.WebReceitaV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.WebReceitaProdutorV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.produtor.model.DTOProdutorRuralResV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.receita.model.DTOReceitaAgroItemResultV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.receita.model.DTOReceitaAgroItemV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.receita.model.DTOReceitaAgroResultV2;
import com.touchcomp.basementorclientwebservices.webreceita.v2.receita.model.DTOReceitaAgroV2;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.stereotype.Component;

@Component
public class WebReceitaReceitaV2
extends WebReceitaV2<DTOProdutorRuralResV2> {
    private final String URL = "https://www.novoreceituarioagronomico.com.br/api/receitas/simple/";
    private final String URL_EMISSAO = "https://www.novoreceituarioagronomico.com.br/api/receitas/emitir/{0}/";
    private final String URL_CONSULTA = "https://www.novoreceituarioagronomico.com.br/api/receitas/simple/{0}/";
    private final String URL_EXCLUSAO = "https://www.novoreceituarioagronomico.com.br/api/receitas/simple/{0}/";
    private final String URL_CANCELAMENTO = "https://www.novoreceituarioagronomico.com.br/api/receitas/cancelar/{0}/";
    private final String URL_ITEM_RECEITA_INSERIR = "https://www.novoreceituarioagronomico.com.br/api/receitas/itens/complex/";
    private final String URL_ITEM_RECEITA_EXCLUIR = "https://www.novoreceituarioagronomico.com.br/api/receitas/itens/complex/{0}/";
    private final String URL_RECEITA_IMPRIMIR = "https://www.novoreceituarioagronomico.com.br/api/receitas/imprimir/?id_receita={0}";
    private final String URL_RECEITA_IMPRIMIR_ANEXO = "https://www.novoreceituarioagronomico.com.br/api/receitas/imprimir-anexo-receita/?id_receita={0}";
    private final String URL_RECEITA_IMPRIMIR_ASS_DIGITAL = "https://www.novoreceituarioagronomico.com.br/api/receitas/imprimir-receita-digital/?id_receita={0}";

    public DTOReceitaAgroResultV2 inserirReceita(WebReceitaConfig config, DTOReceitaAgroV2 receita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            return this.postAndGetOne("https://www.novoreceituarioagronomico.com.br/api/receitas/simple/", config.getSenha(), DTOReceitaAgroResultV2.class, receita);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public void emitirReceita(WebReceitaConfig config, String idReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/receitas/emitir/{0}/", idReceita);
            this.put(url, config.getSenha(), null);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public void cancelarReceita(WebReceitaConfig config, String idReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/receitas/cancelar/{0}/", idReceita);
            this.put(url, config.getSenha(), null);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOReceitaAgroResultV2 consultarReceita(WebReceitaConfig config, String idReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/receitas/simple/{0}/", idReceita);
            return this.buildAndGetOne(url, config.getSenha(), DTOReceitaAgroResultV2.class);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public byte[] imprimirReceita(WebReceitaConfig config, String idReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/receitas/imprimir/?id_receita={0}", idReceita);
            return this.buildAndGetBytes(url, config.getSenha());
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public byte[] imprimirAnexos(WebReceitaConfig config, String idReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/receitas/imprimir-anexo-receita/?id_receita={0}", idReceita);
            return this.buildAndGetBytes(url, config.getSenha());
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public byte[] imprimirReceitaAssinada(WebReceitaConfig config, String idReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            String url = this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/receitas/imprimir-receita-digital/?id_receita={0}", idReceita);
            return this.buildAndGetBytes(url, config.getSenha());
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public DTOReceitaAgroItemResultV2 inserirItemReceita(WebReceitaConfig config, DTOReceitaAgroItemV2 receitaItem) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            return this.postAndGetOne("https://www.novoreceituarioagronomico.com.br/api/receitas/itens/complex/", config.getSenha(), DTOReceitaAgroItemResultV2.class, receitaItem);
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public void excluirReceita(WebReceitaConfig config, Long idReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            this.delete(this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/receitas/simple/{0}/", idReceita), config.getSenha());
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public void excluirItemReceita(WebReceitaConfig config, Long idItemReceita) throws ExceptionIO, ExceptionValidacaoDados {
        try {
            this.delete(this.prepareURL("https://www.novoreceituarioagronomico.com.br/api/receitas/itens/complex/{0}/", idItemReceita), config.getSenha());
        }
        catch (Exception ex) {
            Logger.getLogger(WebReceitaProdutorV2.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }
}

