/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.cnab.pagamento;

import com.touchcomp.basementor.exceptions.ExceptionEnumValueNotFound;
import java.util.Arrays;
import java.util.List;

public enum EnumConstFormaLancamentoCnabPagamento {
    FORMA_LANCAMENTO_01("01", "Cr\u00e9dito em Conta Corrente"),
    FORMA_LANCAMENTO_02("02", "Cheque Pagamento / Administrativo"),
    FORMA_LANCAMENTO_03("03", "DOC/TED"),
    FORMA_LANCAMENTO_04("04", "Cart\u00e3o Sal\u00e1rio"),
    FORMA_LANCAMENTO_05("05", "Cr\u00e9dito em Conta Poupan\u00e7a"),
    FORMA_LANCAMENTO_06("06", "Cr\u00e9dito em Conta Corrente de mesma titularidade"),
    FORMA_LANCAMENTO_07("07", "DOC D"),
    FORMA_LANCAMENTO_10("10", "OP \u00e0 Disposi\u00e7\u00e3o"),
    FORMA_LANCAMENTO_11("11", "Pagamento de Contas e Tributos com C\u00f3digo de Barras"),
    FORMA_LANCAMENTO_13("13", "Pagamento de Concessionaria"),
    FORMA_LANCAMENTO_16("16", "Tributo - DARF Normal"),
    FORMA_LANCAMENTO_17("17", "Tributo - GPS (Guia da Previd\u00eancia Social)"),
    FORMA_LANCAMENTO_18("18", "Tributo - DARF Simples"),
    FORMA_LANCAMENTO_19("19", "Tributo - IPTU ? Prefeituras"),
    FORMA_LANCAMENTO_20("20", "Pagamento com Autentica\u00e7\u00e3o"),
    FORMA_LANCAMENTO_21("21", "Tributo ? DARJ"),
    FORMA_LANCAMENTO_22("22", "Tributo - GARE-SP ICMS"),
    FORMA_LANCAMENTO_23("23", "Tributo - GARE-SP DR"),
    FORMA_LANCAMENTO_24("24", "Tributo - GARE-SP ITCMD"),
    FORMA_LANCAMENTO_25("25", "Tributo - IPVA"),
    FORMA_LANCAMENTO_26("26", "Tributo - Licenciamento"),
    FORMA_LANCAMENTO_27("27", "Tributo ? DPVAT"),
    FORMA_LANCAMENTO_30("30", "Liquida\u00e7\u00e3o de T\u00edtulos do Pr\u00f3prio Banco"),
    FORMA_LANCAMENTO_31("31", "Pagamento de T\u00edtulos de Outros Bancos"),
    FORMA_LANCAMENTO_35("35", "FGTS - GFIP"),
    FORMA_LANCAMENTO_40("40", "Extrato de Conta Corrente"),
    FORMA_LANCAMENTO_41("41", "TED ? Outra Titularidade (1)"),
    FORMA_LANCAMENTO_43("43", "TED ? Mesma Titularidade (1)"),
    FORMA_LANCAMENTO_44("44", "TED para Transfer\u00eancia de Conta Investimento"),
    FORMA_LANCAMENTO_45("45", "PIX Transfer\u00eancia"),
    FORMA_LANCAMENTO_47("47", "PIX QR-CODE"),
    FORMA_LANCAMENTO_50("50", "D\u00e9bito em Conta Corrente"),
    FORMA_LANCAMENTO_70("70", "Extrato para Gest\u00e3o de Caixa"),
    FORMA_LANCAMENTO_71("71", "Dep\u00f3sito Judicial em Conta Corrente"),
    FORMA_LANCAMENTO_72("72", "Dep\u00f3sito Judicial em Poupan\u00e7a"),
    FORMA_LANCAMENTO_91("91", "GNRE e tributos com codigo de barras"),
    FORMA_LANCAMENTO_73("73", "Extrato de Conta Investimento"),
    FORMA_LANCAMENTO_CAB("CAB", "Liquida\u00e7\u00e3o de cobran\u00e7a Safra"),
    FORMA_LANCAMENTO_CC("CC", "Cr\u00e9dito em Conta Corrente"),
    FORMA_LANCAMENTO_CHC("CHC", "Cheque Administrativo"),
    FORMA_LANCAMENTO_COB("COB", "Liquida\u00e7\u00e3o de cobran\u00e7a"),
    FORMA_LANCAMENTO_DOC("DOC", "Documento de cr\u00e9dito"),
    FORMA_LANCAMENTO_TED("TED", "Transfer\u00eancia eletr\u00f4nica dispon\u00edvel");

    private final String codigo;
    private final String descricao;

    private EnumConstFormaLancamentoCnabPagamento(String codigo, String var4) {
        this.codigo = codigo;
        this.descricao = var4;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static EnumConstFormaLancamentoCnabPagamento valueOfFormaLancamento(String codigo) {
        for (EnumConstFormaLancamentoCnabPagamento tipo : EnumConstFormaLancamentoCnabPagamento.values()) {
            if (!tipo.getCodigo().equals(codigo)) continue;
            return tipo;
        }
        throw new ExceptionEnumValueNotFound(EnumConstFormaLancamentoCnabPagamento.class.getName(), String.valueOf(codigo), Arrays.toString((Object[])EnumConstFormaLancamentoCnabPagamento.values()));
    }

    public static boolean isSegmentoA(EnumConstFormaLancamentoCnabPagamento var, String numeroBanco) {
        return EnumConstFormaLancamentoCnabPagamento.getFormaLancamentoSegmentoA(numeroBanco).contains((Object)var);
    }

    public static boolean isSegmentoJ(EnumConstFormaLancamentoCnabPagamento var, String numeroBanco) {
        return EnumConstFormaLancamentoCnabPagamento.getFormaLancamentoSegmentoJ(numeroBanco).contains((Object)var);
    }

    public static boolean isSegmentoO(EnumConstFormaLancamentoCnabPagamento var, String numeroBanco) {
        return EnumConstFormaLancamentoCnabPagamento.getFormaLancamentoSegmentoO(numeroBanco).contains((Object)var);
    }

    public static boolean isSegmentoN(EnumConstFormaLancamentoCnabPagamento var, String numeroBanco) {
        return EnumConstFormaLancamentoCnabPagamento.getFormaLancamentoSegmentoN(numeroBanco).contains((Object)var);
    }

    public static boolean isSegmentoPagBoleto(EnumConstFormaLancamentoCnabPagamento var, String numeroBanco) {
        return EnumConstFormaLancamentoCnabPagamento.getFormaLancamentoPagamentoBoleto(numeroBanco).contains((Object)var);
    }

    public static boolean isSegmentoPagTransferencia(EnumConstFormaLancamentoCnabPagamento var, String numeroBanco) {
        return EnumConstFormaLancamentoCnabPagamento.getFormaLancamentoPagamentoTransferenciaEletronica(numeroBanco).contains((Object)var);
    }

    private static List<EnumConstFormaLancamentoCnabPagamento> getFormaLancamentoSegmentoA(String nrBanco) {
        EnumConstFormaLancamentoCnabPagamento[] aux = null;
        if (nrBanco.equals("001")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_01, FORMA_LANCAMENTO_03, FORMA_LANCAMENTO_05, FORMA_LANCAMENTO_41, FORMA_LANCAMENTO_43};
        } else if (nrBanco.equals("341")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_01, FORMA_LANCAMENTO_02, FORMA_LANCAMENTO_03, FORMA_LANCAMENTO_05, FORMA_LANCAMENTO_06, FORMA_LANCAMENTO_07, FORMA_LANCAMENTO_10, FORMA_LANCAMENTO_11, FORMA_LANCAMENTO_41, FORMA_LANCAMENTO_43};
        } else if (nrBanco.equals("104")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_01, FORMA_LANCAMENTO_02, FORMA_LANCAMENTO_03, FORMA_LANCAMENTO_05, FORMA_LANCAMENTO_10, FORMA_LANCAMENTO_41, FORMA_LANCAMENTO_43, FORMA_LANCAMENTO_50};
        } else if (nrBanco.equals("237")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_01, FORMA_LANCAMENTO_02, FORMA_LANCAMENTO_03, FORMA_LANCAMENTO_05, FORMA_LANCAMENTO_10, FORMA_LANCAMENTO_41, FORMA_LANCAMENTO_43};
        } else if (nrBanco.equals("756")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_01, FORMA_LANCAMENTO_03, FORMA_LANCAMENTO_05, FORMA_LANCAMENTO_41, FORMA_LANCAMENTO_43};
        } else if (nrBanco.equals("033")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_01, FORMA_LANCAMENTO_03, FORMA_LANCAMENTO_05, FORMA_LANCAMENTO_10};
        }
        if (aux == null) {
            throw new ExceptionEnumValueNotFound(EnumConstFormaLancamentoCnabPagamento.class.getName(), String.valueOf(nrBanco), Arrays.toString((Object[])EnumConstFormaLancamentoCnabPagamento.values()));
        }
        return Arrays.asList(aux);
    }

    private static List<EnumConstFormaLancamentoCnabPagamento> getFormaLancamentoSegmentoJ(String nrBanco) {
        EnumConstFormaLancamentoCnabPagamento[] aux = null;
        if (nrBanco.equals("001") || nrBanco.equals("341") || nrBanco.equals("104") || nrBanco.equals("237") || nrBanco.equals("756") || nrBanco.equals("033")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_30, FORMA_LANCAMENTO_31, FORMA_LANCAMENTO_45, FORMA_LANCAMENTO_47};
        }
        if (aux == null) {
            throw new ExceptionEnumValueNotFound(EnumConstFormaLancamentoCnabPagamento.class.getName(), String.valueOf(nrBanco), Arrays.toString((Object[])EnumConstFormaLancamentoCnabPagamento.values()));
        }
        return Arrays.asList(aux);
    }

    private static List<EnumConstFormaLancamentoCnabPagamento> getFormaLancamentoSegmentoO(String nrBanco) {
        EnumConstFormaLancamentoCnabPagamento[] aux = null;
        if (nrBanco.equals("001")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_11, FORMA_LANCAMENTO_19};
        } else if (nrBanco.equals("341")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_13, FORMA_LANCAMENTO_19, FORMA_LANCAMENTO_91};
        } else if (nrBanco.equals("104") || nrBanco.equals("237") || nrBanco.equals("756") || nrBanco.equals("033")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_11};
        }
        if (aux == null) {
            throw new ExceptionEnumValueNotFound(EnumConstFormaLancamentoCnabPagamento.class.getName(), String.valueOf(nrBanco), Arrays.toString((Object[])EnumConstFormaLancamentoCnabPagamento.values()));
        }
        return Arrays.asList(aux);
    }

    private static List<EnumConstFormaLancamentoCnabPagamento> getFormaLancamentoSegmentoN(String nrBanco) {
        EnumConstFormaLancamentoCnabPagamento[] aux = null;
        if (nrBanco.equals("341") || nrBanco.equals("033")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_35};
        }
        if (aux == null) {
            throw new ExceptionEnumValueNotFound(EnumConstFormaLancamentoCnabPagamento.class.getName(), String.valueOf(nrBanco), Arrays.toString((Object[])EnumConstFormaLancamentoCnabPagamento.values()));
        }
        return Arrays.asList(aux);
    }

    private static List<EnumConstFormaLancamentoCnabPagamento> getFormaLancamentoPagamentoBoleto(String nrBanco) {
        EnumConstFormaLancamentoCnabPagamento[] aux = null;
        if (nrBanco.equals("422")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_CAB, FORMA_LANCAMENTO_COB};
        }
        if (aux == null) {
            throw new ExceptionEnumValueNotFound(EnumConstFormaLancamentoCnabPagamento.class.getName(), String.valueOf(nrBanco), Arrays.toString((Object[])EnumConstFormaLancamentoCnabPagamento.values()));
        }
        return Arrays.asList(aux);
    }

    private static List<EnumConstFormaLancamentoCnabPagamento> getFormaLancamentoPagamentoTransferenciaEletronica(String nrBanco) {
        EnumConstFormaLancamentoCnabPagamento[] aux = null;
        if (nrBanco.equals("422")) {
            aux = new EnumConstFormaLancamentoCnabPagamento[]{FORMA_LANCAMENTO_DOC, FORMA_LANCAMENTO_CC, FORMA_LANCAMENTO_TED};
        }
        if (aux == null) {
            throw new ExceptionEnumValueNotFound(EnumConstFormaLancamentoCnabPagamento.class.getName(), String.valueOf(nrBanco), Arrays.toString((Object[])EnumConstFormaLancamentoCnabPagamento.values()));
        }
        return Arrays.asList(aux);
    }
}

