/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.cte.sefaz;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum ConstCTeTomadorServico {
    REMETENTE("0", "Remetente"),
    EXPEDIDOR("1", "Expedidor"),
    RECEBEDOR("2", "Recebedor"),
    DESTINATARIO("3", "Destinat\u00e1rio"),
    OUTROS("4", "Outros");

    public static final List<ConstCTeTomadorServico> TOMADOR_3;
    public static final List<ConstCTeTomadorServico> TOMADOR_4;
    private final String codigo;
    private final String descricao;

    private ConstCTeTomadorServico(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static ConstCTeTomadorServico valueOfCodigo(String codigo) {
        for (ConstCTeTomadorServico tipo : ConstCTeTomadorServico.values()) {
            if (!tipo.getCodigo().equals(codigo)) continue;
            return tipo;
        }
        return null;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }

    static {
        TOMADOR_3 = Arrays.asList(REMETENTE, EXPEDIDOR, RECEBEDOR, DESTINATARIO);
        TOMADOR_4 = Collections.singletonList(OUTROS);
    }
}

