/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.eventonfe;

import java.util.Arrays;
import java.util.List;

public enum NFeConstStatusEventoNFe {
    EVENTO_AGUARDANDO_ENVIO(0),
    EVENTO_REGISTRADO_VINC_NFE(135),
    EVENTO_REGISTRADO_VINC_NFE_DUPLICIDADE(573),
    EVENTO_REGISTRADO_NAO_VINC_NFE(136),
    EVENTO_CIENCIA_NFE_REJ_ERRO_MONTAGEM_ID(572),
    EVENTO_CIENCIA_NFE_REJ_DIVERGENCIA_UF(250),
    EVENTO_CIENCIA_NFE_REJ_DIVERGENCIA_AMBIENTE(252),
    EVENTO_CIENCIA_NFE_REJ_CNPJ_INVALIDO(489),
    EVENTO_CIENCIA_NFE_REJ_CPF_INVALIDO(490),
    EVENTO_CIENCIA_NFE_REJ_DIG_VER_INVALIDO(236),
    EVENTO_CIENCIA_NFE_REJ_CHAVE_INVALIDA(614),
    EVENTO_CIENCIA_NFE_REJ_CHAVE_INVALIDA_ANO(615),
    EVENTO_CIENCIA_NFE_REJ_CHAVE_INVALIDA_MES(616),
    EVENTO_CIENCIA_NFE_REJ_CHAVE_INVALIDA_CNPJ(617),
    EVENTO_CIENCIA_NFE_REJ_CHAVE_INVALIDA_MOD(618),
    EVENTO_CIENCIA_NFE_REJ_CHAVE_INVALIDA_NR(619),
    EVENTO_CIENCIA_NFE_REJ_CHAVE_UF_CHAVE_DIV_UF(249),
    EVENTO_CIENCIA_NFE_REJ_DATA_EVT_MAIOR_PROC(578),
    EVENTO_CIENCIA_NFE_REJ_EMISSOR_INABILITADO(203),
    EVENTO_CIENCIA_NFE_REJ_IRREGULARIDADE_EMISSOR(240),
    EVENTO_CIENCIA_NFE_REJ_OBRIGATORIO_JUSTIFICATIVA(595),
    EVENTO_CIENCIA_NFE_REJ_NR_SEQ_EVT_MAIOR_PERMITIDO(594),
    EVENTO_CIENCIA_NFE_REJ_EVT_FORA_PRAZO(596),
    EVENTO_CIENCIA_NFE_REJ_EVT_SOB_NF_CANC_DENEGADA(650),
    EVENTO_CIENCIA_NFE_REJ_EVT_SOB_NF_CANC_DENEGADA_DESC(651),
    EVENTO_CIENCIA_NFE_REJ_EVT_CIENCIA_APOS_CONFIRMACAO(655);

    private final Integer codigo;

    private NFeConstStatusEventoNFe(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public static NFeConstStatusEventoNFe valueOfCodigo(Object codigo) {
        for (NFeConstStatusEventoNFe tipoEvento : NFeConstStatusEventoNFe.values()) {
            if (!String.valueOf(tipoEvento.getCodigo()).equalsIgnoreCase(String.valueOf(codigo))) continue;
            return tipoEvento;
        }
        return null;
    }

    public String toString() {
        return this.codigo.toString();
    }

    public static boolean isStatusFinal(Short status) {
        NFeConstStatusEventoNFe ev;
        if (status == null) {
            return false;
        }
        List<NFeConstStatusEventoNFe> statsAuto = NFeConstStatusEventoNFe.getStatusFinal();
        return statsAuto.contains((Object)(ev = NFeConstStatusEventoNFe.valueOfCodigo(status)));
    }

    public static boolean isStatusFinalRejeicao(Short status) {
        return status >= 200 && EVENTO_REGISTRADO_VINC_NFE_DUPLICIDADE.getCodigo().shortValue() != status.shortValue();
    }

    public static boolean isNFCancRejeitaIrregular(Short status) {
        return NFeConstStatusEventoNFe.getStatusCanceladaIrregular().contains((Object)NFeConstStatusEventoNFe.valueOfCodigo(status));
    }

    private static List<NFeConstStatusEventoNFe> getStatusCanceladaIrregular() {
        return Arrays.asList(EVENTO_CIENCIA_NFE_REJ_EMISSOR_INABILITADO, EVENTO_CIENCIA_NFE_REJ_IRREGULARIDADE_EMISSOR, EVENTO_CIENCIA_NFE_REJ_EVT_SOB_NF_CANC_DENEGADA, EVENTO_CIENCIA_NFE_REJ_EVT_SOB_NF_CANC_DENEGADA_DESC);
    }

    private static List<NFeConstStatusEventoNFe> getStatusFinal() {
        return Arrays.asList(EVENTO_REGISTRADO_VINC_NFE, EVENTO_REGISTRADO_NAO_VINC_NFE, EVENTO_REGISTRADO_VINC_NFE_DUPLICIDADE, EVENTO_CIENCIA_NFE_REJ_EVT_SOB_NF_CANC_DENEGADA, EVENTO_CIENCIA_NFE_REJ_EVT_SOB_NF_CANC_DENEGADA_DESC, EVENTO_CIENCIA_NFE_REJ_EVT_CIENCIA_APOS_CONFIRMACAO);
    }

    private static List<NFeConstStatusEventoNFe> getStatusValido() {
        return Arrays.asList(EVENTO_REGISTRADO_VINC_NFE, EVENTO_REGISTRADO_NAO_VINC_NFE, EVENTO_REGISTRADO_VINC_NFE_DUPLICIDADE);
    }

    public static boolean isEventoValido(Short status) {
        List<NFeConstStatusEventoNFe> statsAuto = NFeConstStatusEventoNFe.getStatusValido();
        NFeConstStatusEventoNFe ev = NFeConstStatusEventoNFe.valueOfCodigo(status);
        if (ev == null) {
            return false;
        }
        return statsAuto.contains((Object)ev);
    }

    public boolean isStatusFinal() {
        return NFeConstStatusEventoNFe.isStatusFinal(this.getCodigo().shortValue());
    }
}

