/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.nfce;

import java.util.Arrays;
import java.util.List;

public enum EnumConstNFCeTipoAutenticacao {
    AUTENTICACAO_CANCELAMENTO(1, "Cancelamento NFC-e/NF-e"),
    AUTENTICACAO_CANCELAMENTO_ITEM(2, "Cancelamento item NFC-e/NF-e"),
    AUTENTICACAO_DESCONTO_GERAL(3, "Desconto concedido no sobre o total da venda"),
    AUTENTICACAO_DESCONTO_ITEM(4, "Desconto concedido no sobre o item"),
    AUTENTICACAO_ACRESCIMO_GERAL(5, "Acrescimo concedido no sobre o total da venda"),
    AUTENTICACAO_ACRESCIMO_ITEM(6, "Acrecimo concedido no sobre o item"),
    AUTENTICACAO_OPCOES_ABAST_ALT_PRECO(7, "Alteracao Preco Combustivel"),
    AUTENTICACAO_OPCOES_ABAST_BLOQ_ABAST(8, "Bloqueio de Abastecimento"),
    AUTENTICACAO_OPCOES_ABAST_LIB_ABAST(9, "Liberacao de Abastecimento"),
    AUTENTICACAO_OPCOES_ABAST_PARAR_ABAST(10, "Parar Abastecimento"),
    AUTENTICACAO_OPCOES_ABAST_PRE_DET_VAL(11, "Pre determinacao de abastecimento por valor"),
    AUTENTICACAO_ABASTECIMENTO_AFERICAO(12, "Abastecimento de Afericao"),
    AUTENTICACAO_FECHAMENTO_CAIXA(13, "Fechamento de caixa com NFC-e/NF-e ainda pendentes."),
    AUTENTICACAO_REPRESENTANTE(14, "Fechamento de caixa com NFC-e/NF-e ainda pendentes."),
    AUTENTICACAO_CANCELAMENTO_PAGAMENTO(15, "Cancelamento de Pagamento."),
    AUTENTICACAO_LIBERACAO_FINANCEIRA_CLIENTE(16, "Liberacao Financeira de Cliente com pendencias financeiras.");

    private final short value;
    private final String descricao;

    private EnumConstNFCeTipoAutenticacao(short var3, String var4) {
        this.value = var3;
        this.descricao = var4;
    }

    public short getValue() {
        return this.value;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static EnumConstNFCeTipoAutenticacao valueOfCodigo(int var0) {
        for (EnumConstNFCeTipoAutenticacao var4 : EnumConstNFCeTipoAutenticacao.values()) {
            if (var4.getValue() != var0) continue;
            return var4;
        }
        return null;
    }

    public String toString() {
        return this.value + " - " + this.descricao;
    }

    public static boolean isGrupoCancelamentoNFCe(EnumConstNFCeTipoAutenticacao var) {
        return EnumConstNFCeTipoAutenticacao.getliberacaoByGrupoCancelamentoNFCe().contains((Object)var);
    }

    public static boolean isGrupoDescontoAndAcrescimoNFCe(EnumConstNFCeTipoAutenticacao var) {
        return EnumConstNFCeTipoAutenticacao.getliberacaoByGrupoDescontoAndAcrescimoNFCe().contains((Object)var);
    }

    public static boolean isGrupoOpcoesAvanAbastecimento(EnumConstNFCeTipoAutenticacao var) {
        return EnumConstNFCeTipoAutenticacao.getliberacaoByGrupoOpcoesAvanAbastecimento().contains((Object)var);
    }

    public static boolean isGrupoAfericaoPreAbastecimento(EnumConstNFCeTipoAutenticacao var) {
        return EnumConstNFCeTipoAutenticacao.getliberacaoByGrupoAfericaoPreAbastecimento().contains((Object)var);
    }

    public static boolean isAutenticacaoRepresentante(EnumConstNFCeTipoAutenticacao var) {
        return EnumConstNFCeTipoAutenticacao.getAutenticacaoRepresentante().contains((Object)var);
    }

    public static boolean isGrupoLibFinanceira(EnumConstNFCeTipoAutenticacao var) {
        return EnumConstNFCeTipoAutenticacao.getliberacaoByGrupoLibFinanceira().contains((Object)var);
    }

    public static List<EnumConstNFCeTipoAutenticacao> getliberacaoByGrupoCancelamentoNFCe() {
        EnumConstNFCeTipoAutenticacao[] aux = new EnumConstNFCeTipoAutenticacao[]{AUTENTICACAO_CANCELAMENTO, AUTENTICACAO_CANCELAMENTO_ITEM, AUTENTICACAO_FECHAMENTO_CAIXA};
        return Arrays.asList(aux);
    }

    public static List<EnumConstNFCeTipoAutenticacao> getliberacaoByGrupoLibFinanceira() {
        EnumConstNFCeTipoAutenticacao[] aux = new EnumConstNFCeTipoAutenticacao[]{AUTENTICACAO_LIBERACAO_FINANCEIRA_CLIENTE};
        return Arrays.asList(aux);
    }

    public static List<EnumConstNFCeTipoAutenticacao> getliberacaoByGrupoDescontoAndAcrescimoNFCe() {
        EnumConstNFCeTipoAutenticacao[] aux = new EnumConstNFCeTipoAutenticacao[]{AUTENTICACAO_DESCONTO_GERAL, AUTENTICACAO_DESCONTO_ITEM, AUTENTICACAO_ACRESCIMO_GERAL, AUTENTICACAO_ACRESCIMO_ITEM, AUTENTICACAO_CANCELAMENTO_PAGAMENTO};
        return Arrays.asList(aux);
    }

    public static List<EnumConstNFCeTipoAutenticacao> getliberacaoByGrupoOpcoesAvanAbastecimento() {
        EnumConstNFCeTipoAutenticacao[] aux = new EnumConstNFCeTipoAutenticacao[]{AUTENTICACAO_OPCOES_ABAST_ALT_PRECO, AUTENTICACAO_OPCOES_ABAST_BLOQ_ABAST, AUTENTICACAO_OPCOES_ABAST_LIB_ABAST, AUTENTICACAO_OPCOES_ABAST_PARAR_ABAST, AUTENTICACAO_OPCOES_ABAST_PRE_DET_VAL};
        return Arrays.asList(aux);
    }

    public static List<EnumConstNFCeTipoAutenticacao> getliberacaoByGrupoAfericaoPreAbastecimento() {
        EnumConstNFCeTipoAutenticacao[] aux = new EnumConstNFCeTipoAutenticacao[]{AUTENTICACAO_ABASTECIMENTO_AFERICAO};
        return Arrays.asList(aux);
    }

    public static List<EnumConstNFCeTipoAutenticacao> getAutenticacaoRepresentante() {
        EnumConstNFCeTipoAutenticacao[] aux = new EnumConstNFCeTipoAutenticacao[]{AUTENTICACAO_REPRESENTANTE};
        return Arrays.asList(aux);
    }
}

