/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.nfe;

import com.touchcomp.basementor.constants.enums.EnumBaseInterface;

public enum EnumConstNFeTipoImpressao implements EnumBaseInterface<Short, String>
{
    SEM_GERACAO_DANFE("0", "Sem gera\u00e7\u00e3o de DANFe"),
    DANFE_NORMAL_RETRATO("1", "DANFe normal retrato"),
    DANFE_NORMAL_PAISAGEM("2", "DANFe normal paisagem"),
    DANFE_SIMPLIFICADO("3", "DANFe simplificado"),
    DANFE_NFCE("4", "DANFe NFCe"),
    DANFE_NFCE_MENSAGEM_ELETRONICA("5", "DANFe NFCe mensagem eletr\u00f4nica");

    private final String codigo;
    private final String descricao;

    private EnumConstNFeTipoImpressao(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public static EnumConstNFeTipoImpressao valueOfCodigo(String codigo) {
        for (EnumConstNFeTipoImpressao tipo : EnumConstNFeTipoImpressao.values()) {
            if (!tipo.getCodigo().equals(codigo)) continue;
            return tipo;
        }
        return null;
    }

    public static EnumConstNFeTipoImpressao[] valuesRetratoPaisagem() {
        EnumConstNFeTipoImpressao[] values = new EnumConstNFeTipoImpressao[]{DANFE_NORMAL_RETRATO, DANFE_NORMAL_PAISAGEM};
        return values;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }

    @Override
    public Short getEnumId() {
        return Short.valueOf(this.codigo);
    }

    @Override
    public String getEnumDesc() {
        return this.descricao;
    }
}

