/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.nfe;

public enum EnumConstNFeTipoPagNFe {
    DINHEIRO("01", "Dinheiro"),
    CHEQUE("02", "Cheque"),
    CARTAO_CREDITO("03", "Cartao Credito"),
    CARTAO_DEBITO("04", "Cartao Debito"),
    CREDITO_LOJA("05", "Credito Loja"),
    VALE_ALIMENTACAO("10", "Vale Alimentacao"),
    VALE_REFEICAO("11", "Vale Refeicao"),
    VALE_PRESENTE("12", "Vale Presente"),
    VALE_COMBUSTIVEL("13", "Vale Combustivel"),
    DUPLICATA("14", "Duplicata"),
    BOLETO_BANCARIO("15", "Boleto Bancario"),
    DEPOSITO_BANCARIO("16", "Deposito Bancario"),
    PIX("17", "Pagamento Instantaneo (PIX)"),
    TRANSF_BANC_CARTEIRA_DIGITAL("18", "Transf. Bancaria, Carteira Digital"),
    PROGRAMA_FIDELIDADE_CASHBACK_CREDITO_VIRTUAL("19", "Programa Fidelidade, CashBack, Credito Virtual"),
    SEM_PAGAMENTO("90", "Sem Pagamento"),
    OUTROS("99", "Outros");

    private final String codigo;
    private final String descricao;

    private EnumConstNFeTipoPagNFe(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public static EnumConstNFeTipoPagNFe valueOfCodigo(String codigo) {
        for (EnumConstNFeTipoPagNFe tipo : EnumConstNFeTipoPagNFe.values()) {
            if (!tipo.getCodigo().equals(codigo)) continue;
            return tipo;
        }
        return null;
    }

    public String toString() {
        return this.codigo + " - " + this.descricao;
    }

    public static boolean isCartaoDebCred(String codigo) {
        if (codigo == null) {
            return false;
        }
        EnumConstNFeTipoPagNFe type = EnumConstNFeTipoPagNFe.valueOfCodigo(codigo);
        if (type == null) {
            return false;
        }
        return type.equals((Object)CARTAO_CREDITO) || type.equals((Object)CARTAO_DEBITO) || type.equals((Object)VALE_ALIMENTACAO) || type.equals((Object)VALE_REFEICAO) || type.equals((Object)VALE_COMBUSTIVEL) || type.equals((Object)PIX);
    }

    public static boolean necessitaAnaliseCredito(String codigo) {
        if (codigo == null) {
            return false;
        }
        EnumConstNFeTipoPagNFe type = EnumConstNFeTipoPagNFe.valueOfCodigo(codigo);
        if (type == null) {
            return false;
        }
        return type.equals((Object)BOLETO_BANCARIO) || type.equals((Object)CHEQUE) || type.equals((Object)CREDITO_LOJA) || type.equals((Object)DUPLICATA);
    }
}

