/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.nfse;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public enum EnumConstNSeStatus {
    CRIADO_NAO_ENV(0, "NFS-e criada, nao enviada"),
    AUTORIZADO(100, "Autorizado o uso"),
    CANCELADA(101, "Cancelamento homologado"),
    CANCELADA_SUBSTITUIDA(102, "Cancelamento por substituicao");

    private final Integer value;
    private final String descricao;

    private EnumConstNSeStatus(Integer value, String descricao) {
        this.value = value;
        this.descricao = descricao;
    }

    public static boolean isStatusAutorizado(Integer status) {
        EnumConstNSeStatus aux = EnumConstNSeStatus.getByCodigo(status);
        return EnumConstNSeStatus.isStatusAutorizado(aux);
    }

    public static boolean isStatusAutorizado(EnumConstNSeStatus status) {
        return EnumConstNSeStatus.getStatusAutorizado().contains((Object)status);
    }

    public static List<EnumConstNSeStatus> getStatusAutorizado() {
        EnumConstNSeStatus[] aux = new EnumConstNSeStatus[]{AUTORIZADO};
        return Arrays.asList(aux);
    }

    public static boolean isStatusAutorizadoOuContigencia(Integer status) {
        EnumConstNSeStatus aux = EnumConstNSeStatus.getByCodigo(status);
        return EnumConstNSeStatus.isStatusAutorizadoOuContigencia(aux);
    }

    public static boolean isStatusAutorizadoOuContigencia(EnumConstNSeStatus status) {
        return EnumConstNSeStatus.getStatusAutorizadoOuContigencia().contains((Object)status);
    }

    public static List<EnumConstNSeStatus> getStatusAutorizadoOuContigencia() {
        EnumConstNSeStatus[] aux = new EnumConstNSeStatus[]{AUTORIZADO};
        return Arrays.asList(aux);
    }

    public static boolean isStatusCancelado(Integer status) {
        EnumConstNSeStatus aux = EnumConstNSeStatus.getByCodigo(status);
        return EnumConstNSeStatus.isStatusCancelado(aux);
    }

    public static boolean isStatusCancelado(EnumConstNSeStatus status) {
        return EnumConstNSeStatus.getStatusCancelado().contains((Object)status);
    }

    public static List<EnumConstNSeStatus> getStatusCancelado() {
        EnumConstNSeStatus[] aux = new EnumConstNSeStatus[]{CANCELADA, CANCELADA_SUBSTITUIDA};
        return Arrays.asList(aux);
    }

    public static boolean isStatusFinal(Integer status) {
        EnumConstNSeStatus aux = EnumConstNSeStatus.getByCodigo(status);
        return EnumConstNSeStatus.isStatusFinal(aux);
    }

    public static boolean isStatusFinal(EnumConstNSeStatus status) {
        if (status == null) {
            return false;
        }
        if (EnumConstNSeStatus.isStatusCancelado(status)) {
            return true;
        }
        return EnumConstNSeStatus.isStatusAutorizado(status);
    }

    public static EnumConstNSeStatus[] getStatusFinal() {
        LinkedList<EnumConstNSeStatus> status = new LinkedList<EnumConstNSeStatus>();
        status.addAll(EnumConstNSeStatus.getStatusAutorizado());
        status.addAll(EnumConstNSeStatus.getStatusCancelado());
        return status.toArray(new EnumConstNSeStatus[0]);
    }

    public static boolean isRejeitadaOuNaoEnv(EnumConstNSeStatus status) {
        return EnumConstNSeStatus.isRejeitadaOuNaoEnv(status.getValue());
    }

    public static boolean isRejeitadaOuNaoEnv(Integer status) {
        if (status == null) {
            return true;
        }
        return status < 10 || status >= 200;
    }

    public static boolean isRejeitada(EnumConstNSeStatus status) {
        return EnumConstNSeStatus.isRejeitadaOuNaoEnv(status.getValue());
    }

    public static boolean isRejeitada(Integer status) {
        if (status == null) {
            return true;
        }
        return status >= 200;
    }

    public static EnumConstNSeStatus getByCodigo(String value) {
        EnumConstNSeStatus[] values;
        for (EnumConstNSeStatus value1 : values = EnumConstNSeStatus.values()) {
            if (!Objects.equals(value1.getValue(), Integer.valueOf(value))) continue;
            return value1;
        }
        return null;
    }

    public static EnumConstNSeStatus getByCodigo(Integer value) {
        return EnumConstNSeStatus.getByCodigo(value.toString());
    }

    public Integer getValue() {
        return this.value;
    }

    public Short getValueShort() {
        return this.value.shortValue();
    }

    public String getDescricao() {
        return this.descricao;
    }
}

