/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.situacaodocumento;

import com.touchcomp.basementor.exceptions.ExceptionEnumValueNotFound;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public enum EnumConstSituacaoDocumento {
    REGULAR("00"),
    REGULAR_EXTEMPORANEO("01"),
    CANCELADO("02"),
    CANCELADO_EXTEMPORANEO("03"),
    COMPLEMENTAR("06"),
    COMPLEMENTAR_EXTEMPORANEO("07"),
    DOCUMENTO_RE_NE("08"),
    DENEGADO("04");

    public final String value;

    private EnumConstSituacaoDocumento(String valor) {
        this.value = valor;
    }

    public String getValue() {
        return this.value;
    }

    public static EnumConstSituacaoDocumento get(Object value) {
        for (EnumConstSituacaoDocumento value1 : EnumConstSituacaoDocumento.values()) {
            if (!String.valueOf(value).equalsIgnoreCase(String.valueOf(value1.value))) continue;
            return value1;
        }
        throw new ExceptionEnumValueNotFound(EnumConstSituacaoDocumento.class.getName(), String.valueOf(value), Arrays.toString((Object[])EnumConstSituacaoDocumento.values()));
    }

    public static List<EnumConstSituacaoDocumento> getSituacoesValidas() {
        return Arrays.asList(REGULAR, REGULAR_EXTEMPORANEO, COMPLEMENTAR, COMPLEMENTAR_EXTEMPORANEO, DOCUMENTO_RE_NE);
    }

    public static List<? extends String> getSituacoesValidasStr() {
        List<EnumConstSituacaoDocumento> aux = EnumConstSituacaoDocumento.getSituacoesValidas();
        LinkedList<String> ret = new LinkedList<String>();
        for (EnumConstSituacaoDocumento en : aux) {
            ret.add(en.getValue());
        }
        return ret;
    }

    public static List<EnumConstSituacaoDocumento> getSituacoesInvalidas() {
        return Arrays.asList(CANCELADO, CANCELADO_EXTEMPORANEO, DENEGADO);
    }

    public static List<? extends String> getSituacoesInvalidasStr() {
        List<EnumConstSituacaoDocumento> aux = EnumConstSituacaoDocumento.getSituacoesInvalidas();
        LinkedList<String> ret = new LinkedList<String>();
        for (EnumConstSituacaoDocumento en : aux) {
            ret.add(en.getValue());
        }
        return ret;
    }

    public boolean isCanceladoDenegado() {
        return this.equals((Object)CANCELADO) || this.equals((Object)CANCELADO_EXTEMPORANEO) || this.isDenegado();
    }

    public boolean isDenegado() {
        return this.equals((Object)DENEGADO);
    }

    public boolean isValido() {
        return !this.isCanceladoDenegado();
    }
}

