/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.constants.enums.tiposistemastouch;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemaUpdate;
import java.util.Arrays;
import java.util.List;

public enum EnumConstTipoSistemasTouch {
    INDEFINIDO(0, "Indefinido", "", EnumConstTipoSistemaUpdate.TIPO_APP_LOCAL),
    MENTOR_BD(1, "MENTOR BD", "mentor", EnumConstTipoSistemaUpdate.TIPO_APP_BANCO),
    LOG_BD(5, "LOG BD", "log", EnumConstTipoSistemaUpdate.TIPO_APP_BANCO),
    VERSAO_BD(2, "VERSAO BD", "versao", EnumConstTipoSistemaUpdate.TIPO_APP_BANCO),
    NFE_BD(3, "NFE BD", "nfe", EnumConstTipoSistemaUpdate.TIPO_APP_BANCO),
    ENDERECOS_BD(6, "ENDERECOS BD", "enderecos", EnumConstTipoSistemaUpdate.TIPO_APP_BANCO),
    CUPOM_FISCAL(4, "CUPOM FISCAL BD", "cupom", EnumConstTipoSistemaUpdate.TIPO_APP_BANCO),
    MENTOR_DESKTOP(7, "MENTOR DESKTOP", "", EnumConstTipoSistemaUpdate.TIPO_APP_LOCAL),
    TOUCH_WEB_ANTIGO(8, "MENTOR WEB ANTIGO", "", EnumConstTipoSistemaUpdate.TIPO_APP_WEB),
    ATUALIZADOR(9, "ATUALIZADOR", "", EnumConstTipoSistemaUpdate.TIPO_APP_LOCAL),
    BINARY_BD(12, "BINARY BD", "binary_data", EnumConstTipoSistemaUpdate.TIPO_APP_BANCO),
    MOBILE(11, "MOBILE", "", EnumConstTipoSistemaUpdate.TIPO_APP_MOBILE),
    NFCE(13, "NFCE", "", EnumConstTipoSistemaUpdate.TIPO_APP_LOCAL_BD),
    TOUCH_WEB_API(14, "WEB API", "", EnumConstTipoSistemaUpdate.TIPO_APP_WEB),
    TOUCH_WEB_FRONT(15, "WEB FRONT", "", EnumConstTipoSistemaUpdate.TIPO_APP_WEB);

    private final short value;
    private final String descricao;
    private final String aliases;
    private final EnumConstTipoSistemaUpdate tipoAplicativo;

    private EnumConstTipoSistemasTouch(short valor, String descricao, String aliases, EnumConstTipoSistemaUpdate tipo) {
        this.value = valor;
        this.descricao = descricao;
        this.aliases = aliases;
        this.tipoAplicativo = tipo;
    }

    public int getValue() {
        return this.value;
    }

    public short getValueShort() {
        return this.value;
    }

    public static EnumConstTipoSistemasTouch get(Object value) {
        for (EnumConstTipoSistemasTouch value1 : EnumConstTipoSistemasTouch.values()) {
            if (!String.valueOf(value).equalsIgnoreCase(String.valueOf(value1.value))) continue;
            return value1;
        }
        return INDEFINIDO;
    }

    public String toString() {
        return this.descricao;
    }

    public boolean isBancoDados(EnumConstTipoSistemasTouch tipo) {
        return this.getTiposBD().contains((Object)tipo);
    }

    public boolean isWeb(EnumConstTipoSistemasTouch tipo) {
        return TOUCH_WEB_ANTIGO.equals((Object)tipo) || TOUCH_WEB_FRONT.equals((Object)tipo) || TOUCH_WEB_API.equals((Object)tipo);
    }

    public boolean isMobile(EnumConstTipoSistemasTouch tipo) {
        return MOBILE.equals((Object)tipo);
    }

    private List<EnumConstTipoSistemasTouch> getTiposBD() {
        return Arrays.asList(BINARY_BD, ENDERECOS_BD, LOG_BD, MENTOR_BD, NFE_BD, VERSAO_BD);
    }

    public static List<EnumConstTipoSistemasTouch> getSistemasDesktop() {
        return Arrays.asList(ATUALIZADOR, CUPOM_FISCAL, MENTOR_DESKTOP, NFCE);
    }

    public static List<EnumConstTipoSistemasTouch> getBancoDados(EnumConstTipoSistemasTouch tipo) {
        if (tipo.equals((Object)MENTOR_DESKTOP)) {
            return Arrays.asList(BINARY_BD, ENDERECOS_BD, LOG_BD, MENTOR_BD, NFE_BD, VERSAO_BD);
        }
        if (tipo.equals((Object)NFCE)) {
            return Arrays.asList(BINARY_BD, ENDERECOS_BD, LOG_BD, MENTOR_BD, NFE_BD, VERSAO_BD);
        }
        return Arrays.asList(new EnumConstTipoSistemasTouch[0]);
    }

    public String getAliases() {
        return this.aliases;
    }

    public EnumConstTipoSistemaUpdate getTipoAplicativo() {
        return this.tipoAplicativo;
    }

    public boolean isApp() {
        return this.equals((Object)CUPOM_FISCAL) || this.equals((Object)MENTOR_DESKTOP) || this.equals((Object)TOUCH_WEB_ANTIGO) || this.equals((Object)MOBILE) || this.equals((Object)NFCE) || this.equals((Object)TOUCH_WEB_API) || this.equals((Object)TOUCH_WEB_FRONT);
    }

    public boolean isWebApp() {
        return this.equals((Object)TOUCH_WEB_ANTIGO) || this.equals((Object)TOUCH_WEB_API) || this.equals((Object)TOUCH_WEB_FRONT);
    }
}

