/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorexceptions.exceptions;

import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import java.util.Objects;

public class ExceptionBase
extends Exception {
    private final String errorCode;
    private static final long serialVersionUID = -347532309817295568L;

    public ExceptionBase(String errorCodeParam) {
        super(ExceptionBase.getMessage(errorCodeParam, new Object[0]));
        this.errorCode = errorCodeParam;
    }

    public ExceptionBase(ExcepCodeDetail excep) {
        super(ExceptionRuntimeBase.getMessageError(excep.getErrorCode(), excep.getDetails()));
        this.errorCode = excep.getErrorCode();
    }

    public ExceptionBase(String errorCodeParam, Object ... moreInfo) {
        super(ExceptionBase.getMessage(errorCodeParam, moreInfo));
        this.errorCode = errorCodeParam;
    }

    public ExceptionBase(String errorCodeParam, Throwable mainException, Object ... moreInfo) {
        super(ExceptionBase.getMessage(errorCodeParam, moreInfo), mainException);
        this.errorCode = errorCodeParam;
    }

    protected static String getMessage(String errorCodeParam, Object ... moreInfo) {
        String msg = MessagesBaseMentor.getErrorMsg((String)errorCodeParam, (Object[])moreInfo);
        if (Objects.equals(errorCodeParam, msg)) {
            return msg;
        }
        return errorCodeParam + " - " + msg;
    }

    public String getFormattedMessage() {
        return this.getLocalizedMessage();
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

