/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorexceptions.exceptions;

import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementormessages.MessagesBaseMentor;

public class ExceptionRuntimeBase
extends RuntimeException {
    private ExcepCodeDetail errorCodeDetail;
    private String message;
    private static final long serialVersionUID = -347532309817295568L;

    public ExceptionRuntimeBase(ExcepCodeDetail excep) {
        super(ExceptionRuntimeBase.getMessageError(excep.getErrorCode(), excep.getDetails()));
        this.errorCodeDetail = excep;
    }

    public ExceptionRuntimeBase(ExcepCodeDetail excep, Throwable cause) {
        super(ExceptionRuntimeBase.getMessageError(excep.getErrorCode(), excep.getDetails()), cause);
        this.errorCodeDetail = excep;
    }

    public ExceptionRuntimeBase(String message) {
        super(ExceptionRuntimeBase.getMessageError(message, new Object[0]));
    }

    public ExceptionRuntimeBase(String message, Throwable cause) {
        super(message, cause);
    }

    public ExceptionRuntimeBase(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCodeDetail = new ExcepCodeDetail(errorCode);
        this.message = message;
    }

    public ExceptionRuntimeBase(String errorCode, Throwable cause, Object ... moreInfo) {
        super(cause);
        this.errorCodeDetail = new ExcepCodeDetail(errorCode);
        this.message = MessagesBaseMentor.getErrorMsg((String)errorCode, (Object[])moreInfo);
    }

    public static String getMessageError(String errorCode, Object ... moreInfo) {
        return errorCode + " - " + MessagesBaseMentor.getErrorMsg((String)errorCode, (Object[])moreInfo);
    }

    public static String getMessageErrorBD(String errorCode, Object ... moreInfo) {
        return errorCode + " - " + MessagesBaseMentor.getErrorMsgBD((String)errorCode, (Object[])moreInfo);
    }

    public ExceptionRuntimeBase(ExceptionBase ex) {
        super(ex.getFormattedMessage(), ex);
        this.errorCodeDetail = new ExcepCodeDetail(ex.getErrorCode());
        this.message = ex.getFormattedMessage();
    }

    public String getFormattedMessage() {
        if (this.message != null && this.message.length() > 0) {
            return this.message;
        }
        if (this.errorCodeDetail != null) {
            return this.errorCodeDetail.getErrorCode() + " - " + MessagesBaseMentor.getErrorMsg((String)this.errorCodeDetail.getErrorCode(), (Object[])this.errorCodeDetail.getDetails());
        }
        String ret = MessagesBaseMentor.getErrorMsg((String)this.getLocalizedMessage(), (Object[])new Object[0]);
        if (ret != null && ret.trim().length() > 0) {
            return ret;
        }
        return this.getLocalizedMessage();
    }

    public ExcepCodeDetail getDetail() {
        return this.errorCodeDetail;
    }
}

