/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorexceptions.exceptions.impl.database;

import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorexceptions.exceptions.util.UtilException;
import com.touchcomp.basementormessages.MessagesBaseMentor;

public class ExceptionUtilDatabase {
    private static final String CARD_UNIQUE_PRIMARY_KEY = "violationofPRIMARYorUNIQUEKEYconstraint";
    private static final String CARD_FOREIGN_KEY = "violationofFOREIGNKEYconstraint";
    private static final String CARD_SQL_ERROR = "DynamicSQLError";
    private static final String CARD_COULD_NOT_CONNECT = "Unabletocompletenetworkrequest";
    private static final String PREFIX_PRIMARY_KEY = "PK";
    private static final String PREFIX_UNIQUE_KEY = "UNQ";

    public static ExcepCodeDetail checkException(Throwable ex) {
        String fullStatck = UtilException.getFullStack(ex, true);
        if (fullStatck.contains(CARD_UNIQUE_PRIMARY_KEY)) {
            return ExceptionUtilDatabase.checkUniqueOrPrimaryKey(fullStatck);
        }
        if (fullStatck.contains(CARD_FOREIGN_KEY)) {
            return ExceptionUtilDatabase.checkForeignKey(fullStatck);
        }
        if (fullStatck.contains(CARD_SQL_ERROR)) {
            return ExceptionUtilDatabase.checkSQLError(fullStatck);
        }
        if (fullStatck.contains(CARD_COULD_NOT_CONNECT)) {
            return ExceptionUtilDatabase.checkCouldNotConnect(fullStatck);
        }
        return new ExcepCodeDetail("E.TBD.000007", ex.getMessage());
    }

    private static ExcepCodeDetail checkUniqueOrPrimaryKey(String full) {
        int index = full.indexOf(CARD_UNIQUE_PRIMARY_KEY);
        index += CARD_UNIQUE_PRIMARY_KEY.length();
        String key = full.substring(++index);
        boolean isPrimary = key.startsWith(PREFIX_PRIMARY_KEY);
        String msg = null;
        if (isPrimary) {
            index = key.indexOf("\"");
            key = key.substring(0, index);
            msg = MessagesBaseMentor.getDefMsgUnique((String)key, (Object[])new Object[0]);
            return new ExcepCodeDetail("E.TBD.000003", msg);
        }
        index = key.indexOf("\"");
        key = key.substring(0, index);
        msg = MessagesBaseMentor.getDefMsgUnique((String)key, (Object[])new Object[0]);
        return new ExcepCodeDetail("E.TBD.000001", msg);
    }

    private static ExcepCodeDetail checkForeignKey(String full) {
        String ON_TABLE = "ontable";
        int index = full.indexOf(CARD_FOREIGN_KEY);
        String key = full.substring(++index + CARD_FOREIGN_KEY.length());
        index = key.indexOf(ON_TABLE);
        key = key.substring(++index + ON_TABLE.length());
        index = key.indexOf("\"");
        key = key.substring(0, index);
        String msg = MessagesBaseMentor.getDefMsgUnique((String)key, (Object[])new Object[0]);
        return new ExcepCodeDetail("E.TBD.000002", msg);
    }

    private static ExcepCodeDetail checkSQLError(String fullStatck) {
        return new ExcepCodeDetail("E.TBD.000005");
    }

    private static ExcepCodeDetail checkCouldNotConnect(String fullStatck) {
        return new ExcepCodeDetail("E.TBD.000006");
    }
}

