/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorlogger.impl;

import com.touchcomp.basementorlogger.model.TouchException;
import java.util.ArrayList;
import java.util.List;

public class Repository {
    private static Repository instance;
    private List<TouchException> exceptionsNotReport = new ArrayList<TouchException>();

    private Repository() {
    }

    public static synchronized Repository getInstance() {
        if (instance == null) {
            instance = new Repository();
        }
        return instance;
    }

    public Boolean report(String message) {
        if (message == null) {
            return false;
        }
        String codigo = this.getCodigo(message);
        if (codigo == null) {
            return true;
        }
        if (codigo.startsWith("W.ERP")) {
            return false;
        }
        if (codigo.startsWith("E.N")) {
            return false;
        }
        if (this.exceptionsNotReport == null || this.exceptionsNotReport.isEmpty()) {
            return false;
        }
        for (TouchException e : this.exceptionsNotReport) {
            if (!(e.getCodigo().matches(".*\\d{3}$") ? e.getCodigo().equals(codigo) : message.contains(e.getCodigo()))) continue;
            return false;
        }
        return true;
    }

    public String getCodigo(String message) {
        String[] parts;
        if (message != null && (parts = message.split("-")).length > 0) {
            return this.processaCodigo(parts);
        }
        return null;
    }

    private String processaCodigo(String[] parts) {
        Object codigo = parts[0].trim();
        Integer aux = 1;
        while (aux < parts.length) {
            if (this.stringIsANumber(parts[aux]).booleanValue()) {
                codigo = (String)codigo + "-" + parts[aux];
                Integer n = aux;
                aux = aux + 1;
                continue;
            }
            aux = parts.length;
        }
        return codigo;
    }

    private Boolean stringIsANumber(String number) {
        if (number == null || number.isEmpty()) {
            return false;
        }
        return number.matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+");
    }

    public List<TouchException> getExceptionsNotReport() {
        return this.exceptionsNotReport;
    }

    public void setExceptionsNotReport(List<TouchException> exceptionsNotReport) {
        this.exceptionsNotReport = exceptionsNotReport;
    }
}

