/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.calculorateio;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementorrules.calculorateio.CompRuleCalcBase;
import com.touchcomp.basementorrules.calculorateio.SourcePercValor;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;

public class CompRuleCalcRateioPercValor
extends CompRuleCalcBase {
    public void ratearValor(List<SourcePercValor> itens, Double valor) {
        this.ratearValor(itens, valor, EnumConstantsMentorSimNao.NAO);
    }

    public void ratearPercentual(List<SourcePercValor> itens, Double percentual) {
        this.ratearPercentual(itens, percentual, EnumConstantsMentorSimNao.NAO);
    }

    public void ratearPercentual(List<SourcePercValor> itens, Double percentual, EnumConstantsMentorSimNao limitarValorMinimo) {
        this.ratearValores(itens, 0.0, percentual, limitarValorMinimo, true);
    }

    public void ratearValor(List<SourcePercValor> itens, Double valor, EnumConstantsMentorSimNao limitarValorMinimo) {
        this.ratearValores(itens, valor, 0.0, limitarValorMinimo, false);
    }

    private void ratearValores(List<SourcePercValor> itens, Double valor, Double percentual, EnumConstantsMentorSimNao limitarValorMinimo, boolean isPerc) {
        double valorTotal = 0.0;
        if (isPerc) {
            valor = 0.0;
        }
        for (SourcePercValor it : itens) {
            if (!it.isPermitirRateio()) continue;
            valorTotal += it.getBaseCalc().doubleValue();
        }
        if (valorTotal <= 0.0) {
            return;
        }
        double valorDescTotal = 0.0;
        if (!isPerc) {
            percentual = valor / valorTotal * 100.0;
        }
        boolean ajustarUltItem = true;
        for (SourcePercValor item : itens) {
            if (!item.isPermitirRateio()) continue;
            double vlrItem = item.getBaseCalc();
            double vlrMinimo = item.getValorMinimo();
            item.setValor(this.arredondar(percentual / 100.0 * vlrItem));
            item.setPercentual(percentual);
            double vlrItemDesc = item.getBaseCalc() - item.getValor();
            if (vlrItemDesc < item.getValorMinimo() && ToolMethods.isEquals((Object)EnumConstantsMentorSimNao.SIM, (Object)limitarValorMinimo)) {
                ajustarUltItem = false;
                item.setValor(vlrItem - vlrMinimo);
                item.setPercentual((vlrItem - vlrMinimo) / vlrItem * 100.0);
            }
            valorDescTotal += item.getValor().doubleValue();
        }
        if (ajustarUltItem && !isPerc) {
            this.ajustaUltimoItem(itens, valor, valorDescTotal);
        }
    }
}

