/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.funrural;

import com.touchcomp.basementor.constants.enums.impostos.funrural.EnumConstTipoCalcFunrural;
import com.touchcomp.basementorrules.impostos.funrural.model.FunruralCalculado;
import com.touchcomp.basementorrules.impostos.funrural.model.FunruralParams;

public class CompImpostoFunrural {
    public static FunruralCalculado calcularFunrural(FunruralParams params) {
        double baseCalculo = params.getBaseCalculo();
        FunruralCalculado calc = new FunruralCalculado(params);
        if (params.getTipoCalcFunrural() == EnumConstTipoCalcFunrural.CALCULAR_NORMAL) {
            double bcFunrural = 0.0;
            bcFunrural = params.getPercRedFunrural() > 0.0 ? baseCalculo - baseCalculo * (params.getPercRedFunrural() / 100.0) : baseCalculo;
            calc.setAliquotaFunrural(params.getAliquotaFunrural());
            calc.setValorFunrural(params.getAliquotaFunrural() / 100.0 * bcFunrural);
            calc.setPercRedFunrural(params.getPercRedFunrural());
            calc.setBaseCalculoFunrural(bcFunrural);
        } else if (params.getTipoCalcFunrural() == EnumConstTipoCalcFunrural.HABILITAR) {
            calc.setAliquotaFunrural(params.getAliquotaFunrural());
            calc.setValorFunrural(params.getValorFunrural());
            calc.setPercRedFunrural(params.getPercRedFunrural());
            calc.setBaseCalculoFunrural(baseCalculo);
        }
        double valorFunrural = calc.getValorFunrural();
        if (valorFunrural < params.getValorMinimoFunrural()) {
            calc.setValorFunrural(0.0);
        }
        return calc;
    }
}

