/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstContrEstadoIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaFCP;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifal;
import com.touchcomp.basementor.constants.enums.number.EnumConstTipoArredondamento;
import com.touchcomp.basementor.constants.enums.uf.EnumConstUF;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.EnumExcepImpostoIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculoImpl;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementorrules.impostos.icms.tools.TRulesIcms;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.util.Iterator;
import java.util.List;

public class CompImpostoIcms
extends BaseIcms {
    public static IcmsCalculado calcularIcms(IcmsParams params) throws ExceptionImpostoIcms {
        try {
            List listeners = TMethods.isEquals((Object)params.getEntradaSaida(), (Object)EnumConstantsMentorEntSaida.ENTRADA) ? ToolReflections.getClassesFromInterface((String)(InterfaceIcmsCalculoImpl.class.getPackage().getName() + ".entrada"), InterfaceIcmsCalculoImpl.class) : ToolReflections.getClassesFromInterface((String)(InterfaceIcmsCalculoImpl.class.getPackage().getName() + ".saida"), InterfaceIcmsCalculoImpl.class);
            InterfaceIcmsCalculoImpl found = CompImpostoIcms.filter(listeners, params);
            if (found == null) {
                throw new ExceptionImpostoIcms(EnumExcepImpostoIcms.INCIDENCIA_NAO_MAPEADA_CALC, new Object[]{params.getIncidenciaIcms()});
            }
            if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.ENTRADA && !TMethods.isEquals((Object)EnumConstantsMentorEntSaida.ENTRADA, (Object)found.operacao())) {
                throw new ExceptionImpostoIcms(EnumExcepImpostoIcms.INCIDENCIA_INVALIDA_ENTRADA, new Object[]{params.getIncidenciaIcms()});
            }
            if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.SAIDA && !TMethods.isEquals((Object)EnumConstantsMentorEntSaida.SAIDA, (Object)found.operacao())) {
                throw new ExceptionImpostoIcms(EnumExcepImpostoIcms.INCIDENCIA_INVALIDA_SAIDA, new Object[]{params.getIncidenciaIcms()});
            }
            IcmsCalculado calc = found.calcular(params);
            if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.SAIDA) {
                CompImpostoIcms.doAfterSaida(params, calc);
            } else {
                CompImpostoIcms.doAfter(params, calc);
            }
            return calc;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new ExceptionErroProgramacao(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ExceptionErroProgramacao(e.getMessage(), (Throwable)e);
        }
    }

    private static void doAfter(IcmsParams params, IcmsCalculado calc) {
        if (params.getEmbutirIpiBCIcms() == EnumConstantsMentorSimNao.SIM && params.getIpiCalculado().getIpiParams().getIpiCompoeBCIcms() == EnumConstantsMentorSimNao.NAO) {
            calc.setValorIcmsOutros(calc.getValorIcmsOutros() + params.getIpiCalculado().getValorIpiCompoeBCICMS());
        }
        if (params.getEmbutirIcmsSTBCIcms() == EnumConstantsMentorSimNao.SIM) {
            calc.setValorIcmsOutros(calc.getValorIcmsOutros() + calc.getValorIcmsST());
        }
        calc.setPercentualDiferimento(params.getParamsCalcIcms().getPercDiferimento());
        calc.setPercentualRedBC(params.getParamsCalcIcms().getPercRedBCIcms());
        if (TMethods.isEquals((Object)params.getEntradaSaida(), (Object)EnumConstantsMentorEntSaida.SAIDA)) {
            CompImpostoIcms.calcularIcmsDesoneradoSuframa(params, calc);
        }
    }

    private static void doAfterSaida(IcmsParams params, IcmsCalculado calc) throws ExceptionImpostoIcms {
        if (TMethods.isNotNull((Object)params.getParamsCalcIcms().getEmbutirIpiIcmsOutros()).booleanValue() && TMethods.isAffirmative((Number)params.getParamsCalcIcms().getEmbutirIpiIcmsOutros().getValue())) {
            calc.setValorIcmsOutros(calc.getValorIcmsOutros() + (params.getIpiCalculado().getValorIpiIndustria() + params.getIpiCalculado().getValorIpiObservacao()));
        }
        if (TMethods.isEquals((Object)params.getParamsCalcIcms().getIncluirDespAcess(), (Object)EnumConstantsMentorSimNao.NAO) && params.getValorDespAcessorias() > 0.0) {
            calc.setValorIcmsOutros(calc.getValorIcmsOutros() + params.getValorDespAcessorias());
        }
        if (TMethods.isEquals((Object)params.getParamsCalcIcms().getIncluirFrete(), (Object)EnumConstantsMentorSimNao.NAO) && params.getValorFrete() > 0.0) {
            calc.setValorIcmsOutros(calc.getValorIcmsOutros() + params.getValorFrete());
        }
        if (TMethods.isEquals((Object)params.getParamsCalcIcms().getIncluirSeguro(), (Object)EnumConstantsMentorSimNao.NAO) && params.getValorSeguro() > 0.0) {
            calc.setValorIcmsOutros(calc.getValorIcmsOutros() + params.getValorSeguro());
        }
        if (TMethods.isEquals((Object)params.getEmbutirIcmsSTBCIcms(), (Object)EnumConstantsMentorSimNao.SIM)) {
            calc.setValorIcmsOutros(calc.getValorIcmsOutros() + calc.getValorIcmsST());
        }
        Double percentualPartilha = TRulesIcms.getPercentualPartilhaIcms(params);
        if (TMethods.isEquals((Object)params.getParamsCalcIcms().getTipoAliquotaFCP(), (Object)EnumConstTipoAliquotaFCP.CALCULAR_FCP_SOMENTE_DIFAL.getValue())) {
            params.getParamsCalcIcms().setAliquotaFCP(params.getParamsCalcIcms().getAliquotaFCPUF());
        }
        calc.setPercentualDiferimento(params.getParamsCalcIcms().getPercDiferimento());
        calc.setPercentualRedBC(params.getParamsCalcIcms().getPercRedBCIcms());
        CompImpostoIcms.calcularIcmsPartilha(percentualPartilha, params, calc);
        CompImpostoIcms.calcularIcmsDesoneradoSuframa(params, calc);
    }

    private static void calcularIcmsPartilha(Double percentualPartilha, IcmsParams params, IcmsCalculado calc) throws ExceptionImpostoIcms {
        if (TMethods.isEquals((Object)EnumConstModFiscalDifal.TIPO_DIFAL_NAO_CALCULAR.getValue(), (Object)params.getParamsCalcIcms().getTipoDifal())) {
            return;
        }
        if (TMethods.isEquals((Object)params.getConsumidorFinal(), (Object)EnumConstantsMentorSimNao.SIM) && !TMethods.isEquals((Object)params.getUfOrigem(), (Object)params.getUfDestino()) && !TMethods.isEquals((Object)params.getUfDestino(), (Object)EnumConstUF.EX) && TMethods.isEquals((Object)params.getContribuinteEstado(), (Object)EnumConstContrEstadoIcms.NAO_CONTRIBUINTE)) {
            Double baseCalculo = calc.getValorIcmsTributado();
            Double vrIcms = calc.getValorIcms();
            if (TMethods.isNotNull((Object)vrIcms).booleanValue() && vrIcms > 0.0) {
                Double aliqInternaDest = TRulesIcms.getAliquotaInternaUFDestinatario(params);
                Double aliqInterestadual = params.getParamsCalcIcms().getAliquotaIcmsInformada();
                Double diferenca = Math.abs(aliqInternaDest - aliqInterestadual);
                if (diferenca >= 0.0 && TMethods.isEquals((Object)EnumConstModFiscalDifal.TIPO_DIFAL_CALCULAR, (Object)params.getParamsCalcIcms().getTipoDifal())) {
                    Double valorIcmsACalcular = ToolFormatter.arrredondarNumero((Double)(baseCalculo * diferenca / 100.0), (int)2);
                    Double vrIcmsUFDest = ToolFormatter.arrredondarNumero((Double)(valorIcmsACalcular * percentualPartilha / 100.0), (int)2, (int)params.getTipoArredondamento().getValue());
                    if (TMethods.isEquals((Object)params.getEntradaSaida(), (Object)EnumConstantsMentorEntSaida.SAIDA)) {
                        calc.setValorIcmsUFDest(vrIcmsUFDest);
                        calc.setValorIcmsUFRem(valorIcmsACalcular - vrIcmsUFDest);
                    } else {
                        calc.setValorIcmsUFDest(valorIcmsACalcular - vrIcmsUFDest);
                        calc.setValorIcmsUFRem(vrIcmsUFDest);
                    }
                    calc.setValorBcIcmsUfDest(baseCalculo);
                    calc.setAliquotaInternaUFDest(aliqInternaDest);
                    calc.setAliquotaInterestadualIcms(aliqInterestadual);
                    calc.setPercPartilhaIcms(percentualPartilha);
                    if (TMethods.isNotNull((Object)params.getParamsCalcIcms().getAliquotaFCP()).booleanValue() && params.getParamsCalcIcms().getAliquotaFCP() > 0.0) {
                        calc.setAliquotaFCP(params.getParamsCalcIcms().getAliquotaFCP());
                        calc.setValorFCP(baseCalculo * (params.getParamsCalcIcms().getAliquotaFCP() / 100.0));
                    }
                } else {
                    calc.setAliquotaInterestadualIcms(aliqInterestadual);
                    calc.setPercPartilhaIcms(percentualPartilha);
                }
            } else if (TMethods.isEquals((Object)params.getIncidenciaIcms(), (Object)EnumConstNFeIncidenciaIcms.SIMPLES_TRIBUTADA_COM_PERMISSAO_CREDITO) || TMethods.isEquals((Object)params.getIncidenciaIcms(), (Object)EnumConstNFeIncidenciaIcms.SIMPLES_TRIBUTADA_SEM_PERMISSAO_CREDITO) || TMethods.isEquals((Object)params.getIncidenciaIcms(), (Object)EnumConstNFeIncidenciaIcms.SIMPLES_ISENCAO_ICMS_FAIXA_RECEITA_BRUTA) || TMethods.isEquals((Object)params.getIncidenciaIcms(), (Object)EnumConstNFeIncidenciaIcms.SIMPLES_IMUNE) || TMethods.isEquals((Object)params.getIncidenciaIcms(), (Object)EnumConstNFeIncidenciaIcms.SIMPLES_NAO_TRIBUTADA) || TMethods.isEquals((Object)params.getIncidenciaIcms(), (Object)EnumConstNFeIncidenciaIcms.SIMPLES_ICMS_COBRADO_ANTERIORMENTE_POR_SUBSTITUICAO_TRIBUTARIA_SUBSIDIO_OU_POR_ANTECIPACAO)) {
                Double aliqInterestadual = params.getParamsCalcIcms().getAliquotaIcmsOrigemDestino();
                calc.setBaseCalculoIcmsUFDest(0.0);
                calc.setAliquotaInternaUFDest(0.0);
                calc.setAliquotaInterestadualIcms(aliqInterestadual);
                calc.setPercPartilhaIcms(percentualPartilha);
                calc.setValorIcmsUFRem(0.0);
                calc.setValorIcmsUFDest(0.0);
                if (TMethods.isNotNull((Object)params.getParamsCalcIcms().getAliquotaFCP()).booleanValue() && params.getParamsCalcIcms().getAliquotaFCP() > 0.0) {
                    calc.setAliquotaFCP(params.getParamsCalcIcms().getAliquotaFCP());
                    calc.setValorFCP(baseCalculo * (params.getParamsCalcIcms().getAliquotaFCP() / 100.0));
                }
            }
            calc.setAliquotaFCP(0.0);
            calc.setAliquotaFCPST(0.0);
            calc.setAliquotaFCPSTRetido(0.0);
            calc.setValorFCP(0.0);
            calc.setValorFCPST(0.0);
            calc.setValorFCPSTRetidos(0.0);
            calc.setBaseCalculoFCP(0.0);
            calc.setBaseCalculoFCPST(0.0);
            calc.setBaseCalculoFCPSTRetido(0.0);
        }
    }

    private static void calcularIcmsDesoneradoSuframa(IcmsParams params, IcmsCalculado calc) {
        if (params.getCalcularIcmsDesoneradoSuframa() != null && TMethods.isAffirmative((Number)params.getCalcularIcmsDesoneradoSuframa().getValue()) && params.getPercentualIcmsSufr() != null && params.getPercentualIcmsSufr() > 0.0) {
            Double baseCalculo = calc.getBaseCalculoIcms() != null ? calc.getBaseCalculoIcms() : 0.0;
            EnumConstTipoArredondamento tipoArredondamento = params.getTipoArredondamento() != null ? params.getTipoArredondamento() : EnumConstTipoArredondamento.ROUND_HALF_EVEN;
            calc.setValorIcmsDispensado(ToolFormatter.arrredondarNumero((Double)(params.getPercentualIcmsSufr() / 100.0 * baseCalculo), (int)2, (int)tipoArredondamento.value));
        }
    }

    private static InterfaceIcmsCalculoImpl filter(List<Class> listeners, IcmsParams params) throws InstantiationException, IllegalAccessException {
        InterfaceIcmsCalculoImpl found = null;
        Iterator<Class> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            Class clazz;
            Class clazzCalc = clazz = iterator.next();
            InterfaceIcmsCalculoImpl calc = (InterfaceIcmsCalculoImpl)clazzCalc.newInstance();
            EnumConstNFeIncidenciaIcms codigo = params.getIncidenciaIcms();
            if (!TMethods.isEquals((Object)calc.getIncidencia(), (Object)codigo) || !TMethods.isEquals((Object)params.getEntradaSaida(), (Object)calc.operacao())) continue;
            return calc;
        }
        return found;
    }
}

