/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl;

import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoCalcIcmsST;
import com.touchcomp.basementor.constants.enums.modelofiscalicms.EnumConstModFiscalDifalST;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementor.constants.enums.regimetributario.EnumConstRegimeTributario;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcms;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import com.touchcomp.basementorrules.impostos.icms.tools.TRulesIcms;

public class BaseIcmsST
extends BaseIcms {
    private double getBCST(IcmsParams params) {
        double bcIcmsst = params.getValorProdServ();
        if (this.isAffirmative(params.getParamsCalcST().getIncluirDescontoST()).booleanValue()) {
            bcIcmsst -= params.getValorDesconto().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcST().getIncluirDespAcessST()).booleanValue()) {
            bcIcmsst += params.getValorDespAcessorias().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcST().getIncluirFreteST()).booleanValue()) {
            bcIcmsst += params.getValorFrete().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcST().getIncluirSeguroST()).booleanValue()) {
            bcIcmsst += params.getValorSeguro().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcST().getIncluirIPIST()).booleanValue()) {
            bcIcmsst += params.getIpiCalculado().getValorIpiCompoeBCICMS();
        }
        if (params.getParamsCalcST().getPercRedBCIcmsSTModelo() > 0.0) {
            bcIcmsst -= bcIcmsst * params.getParamsCalcST().getPercRedBCIcmsSTModelo() / 100.0;
        }
        return bcIcmsst;
    }

    protected void calcularSt(IcmsParams params, IcmsCalculado calc) throws ExceptionImpostoIcms {
        this.calcularSt(params, calc, calc.getValorIcms());
    }

    protected void calcularSt(IcmsParams params, IcmsCalculado calc, double valorIcms) throws ExceptionImpostoIcms {
        if (this.isNull(params.getParamsCalcST().getTipoCalcIcmsST()).booleanValue() || this.isEquals(EnumConstTipoCalcIcmsST.NAO_CALCULAR, params.getParamsCalcST().getTipoCalcIcmsST()).booleanValue()) {
            return;
        }
        double bcIcmsst = 0.0;
        bcIcmsst = this.isAffirmative(params.getParamsCalcST().getCalcCreditoPresumidoST()) == false ? this.getBCST(params) : this.getBCSTPresumido(params);
        calc.setBaseCalculoIcmsST(bcIcmsst);
        EnumConstTipoCalcIcmsST tipoCalcIcmsST = params.getParamsCalcST().getTipoCalcIcmsST();
        if (this.isEquals(tipoCalcIcmsST, EnumConstTipoCalcIcmsST.CALCULAR_CATEGORIA).booleanValue()) {
            this.putValoresSTAliquotaST(params, calc);
        } else {
            this.putValoresSTModeloFiscalST(params, calc);
        }
    }

    private void putValoresSTAliquotaST(IcmsParams params, IcmsCalculado calc) {
        calc.setIndiceAlteracaoST(params.getParamsCalcST().getIndiceAlteracaoST());
        calc.setAliquotaIcmsST(params.getParamsCalcST().getAliquotaIcmsST());
        calc.setValorDescontoPadraoST(params.getParamsCalcST().getDescontoPadraoST());
        Double bcSt = this.arrredondarNumero(calc.getBaseCalculoIcmsST() * calc.getIndiceAlteracaoST() - calc.getBaseCalculoIcmsST() * (calc.getValorDescontoPadraoST() / 100.0), 2, params.getTipoArredondamento());
        Double valorSt = bcSt * (calc.getAliquotaIcmsST() / 100.0) - calc.getValorIcms();
        if (this.isAffirmative(params.getParamsCalcST().getCalcCreditoPresumidoST()).booleanValue()) {
            Double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsOrigemDestino();
            Double bc = this.getBCAbatendoSomentePisCofins(params);
            valorSt = valorSt - this.calcIcms(bc, aliquotaIcms, params.getTipoArredondamento());
        }
        if (valorSt < 0.0) {
            valorSt = 0.0;
        }
        calc.setBaseCalculoIcmsST(this.arrredondarNumero(bcSt, 2, params.getTipoArredondamento()));
        calc.setValorIcmsST(this.arrredondarNumero(valorSt, 2, params.getTipoArredondamento()));
        calc.setValorIcmsOutros(this.arrredondarNumero(valorSt, 2, params.getTipoArredondamento()));
    }

    private void putValoresSTModeloFiscalST(IcmsParams params, IcmsCalculado calc) {
        calc.setIndiceAlteracaoST(params.getParamsCalcST().getIndiceAlteracaoST());
        calc.setAliquotaIcmsST(params.getParamsCalcST().getAliquotaIcmsST());
        calc.setValorDescontoPadraoST(params.getParamsCalcST().getDescontoPadraoST());
        Double bcIcmsst = calc.getBaseCalculoIcmsST();
        if (params.getParamsCalcST().getIndiceAlteracaoST() > 0.0) {
            bcIcmsst = this.arrredondarNumero(bcIcmsst * params.getParamsCalcST().getIndiceAlteracaoST(), 2, params.getTipoArredondamento());
        }
        Double bcSt = this.arrredondarNumero(bcIcmsst - bcIcmsst * (calc.getValorDescontoPadraoST() / 100.0), 2, params.getTipoArredondamento());
        Double valorSt = this.calcIcms(bcSt, calc.getAliquotaIcmsST(), params.getTipoArredondamento()) - calc.getValorIcmsST();
        if (this.isAffirmative(params.getParamsCalcST().getCalcCreditoPresumidoST()).booleanValue()) {
            Double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsOrigemDestino();
            valorSt = valorSt - (bcIcmsst - this.calcIcms(bcIcmsst, aliquotaIcms, params.getTipoArredondamento()));
        }
        if (valorSt < 0.0) {
            valorSt = 0.0;
        }
        calc.setBaseCalculoIcmsST(bcSt);
        calc.setValorIcmsST(valorSt);
        calc.setValorIcmsOutros(valorSt);
    }

    protected void calcularFCPSt(IcmsParams params, IcmsCalculado calc) {
        if (this.isEquals(params.getVersaoNFe(), EnumConstNFeVersao.VERSAO_4_00).booleanValue() && !this.isAffirmative(params.getNaoCalcularFCP()).booleanValue()) {
            if (this.isCalcularPartilhaIcms(params)) {
                double aliquotaFCP = this.getAliquotaFCPPartilha(params);
                calc.setAliquotaFCP(aliquotaFCP);
                calc.setValorFCP(calc.getBaseCalculoIcms() * (aliquotaFCP / 100.0));
            } else {
                double aliquotaFCP = this.getAliquotaFCP(params);
                if (calc.getBaseCalculoIcmsST() > 0.0 && aliquotaFCP > 0.0) {
                    calc.setValorFCPST(this.arrredondarNumero(calc.getBaseCalculoIcmsST() * (aliquotaFCP / 100.0), 2, params.getTipoArredondamento()));
                    calc.setAliquotaFCPST(aliquotaFCP);
                    calc.setBaseCalculoFCPST(calc.getBaseCalculoIcmsST());
                    calc.setValorFCP(0.0);
                    calc.setAliquotaFCP(0.0);
                    calc.setBaseCalculoFCP(0.0);
                    calc.setValorFCPSTRetidos(0.0);
                    calc.setAliquotaFCPSTRetido(0.0);
                    calc.setBaseCalculoFCPSTRetido(0.0);
                }
            }
        }
    }

    private double getBCSTPresumido(IcmsParams params) {
        double bcIcmsst = 0.0;
        Double aliqPisSuf = params.getAliqPisSuf();
        Double aliqCofinsSuf = params.getAliqCofinsSuf();
        Double aliqIcmsSuf = params.getAliqIcmsSuf();
        Double aliqIpiSuf = params.getAliqIpiSuf();
        bcIcmsst = this.arrredondarNumero(bcIcmsst - bcIcmsst * ((aliqPisSuf + aliqCofinsSuf) / 100.0), 2, params.getTipoArredondamento());
        bcIcmsst = this.arrredondarNumero(bcIcmsst - bcIcmsst * (aliqIcmsSuf / 100.0), 2, params.getTipoArredondamento());
        bcIcmsst = this.arrredondarNumero(bcIcmsst + bcIcmsst * (aliqIpiSuf / 100.0), 2, params.getTipoArredondamento());
        if (this.isAffirmative(params.getParamsCalcST().getIncluirDescontoST()).booleanValue()) {
            bcIcmsst -= params.getValorDesconto().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcST().getIncluirDespAcessST()).booleanValue()) {
            bcIcmsst += params.getValorDespAcessorias().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcST().getIncluirFreteST()).booleanValue()) {
            bcIcmsst += params.getValorFrete().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcST().getIncluirSeguroST()).booleanValue()) {
            bcIcmsst += params.getValorSeguro().doubleValue();
        }
        if (this.isAffirmative(params.getParamsCalcST().getIncluirIPIST()).booleanValue()) {
            bcIcmsst += params.getIpiCalculado().getValorIpiCompoeBCICMS();
        }
        if (!this.isNull(params.getParamsCalcST().getPercRedBCIcmsSTModelo()).booleanValue() && params.getParamsCalcST().getPercRedBCIcmsSTModelo() > 0.0) {
            bcIcmsst -= bcIcmsst * params.getParamsCalcST().getPercRedBCIcmsSTModelo() / 100.0;
        }
        return bcIcmsst;
    }

    private Double getBCAbatendoSomentePisCofins(IcmsParams params) {
        double bcIcmsst = params.getValorProdServ();
        Double aliqPisSuf = params.getAliqPisSuf();
        Double aliqCofinsSuf = params.getAliqCofinsSuf();
        bcIcmsst = this.arrredondarNumero(bcIcmsst - bcIcmsst * ((aliqPisSuf + aliqCofinsSuf) / 100.0), 2, params.getTipoArredondamento());
        return bcIcmsst;
    }

    private void calcularValoresIcms(IcmsParams params, IcmsCalculado calc, double valorIcms) throws ExceptionImpostoIcms {
        calc.setIndiceAlteracaoST(params.getParamsCalcST().getIndiceAlteracaoST());
        calc.setAliquotaIcmsST(params.getParamsCalcST().getAliquotaIcmsST());
        calc.setValorDescontoPadraoST(params.getParamsCalcST().getDescontoPadraoST());
        if ((this.isEquals(params.getRegimeTributario(), EnumConstRegimeTributario.SIMPLES_NACIONAL).booleanValue() || this.isEquals(params.getRegimeTributario(), EnumConstRegimeTributario.SIMPLES_NACIONAL_SUBLIMITE_RECEITA).booleanValue()) && calc.getAliquotaIcms() > 0.0) {
            valorIcms = calc.getBaseCalculoIcmsST() * calc.getAliquotaIcms() / 100.0;
        }
        Double bcSt = calc.getBaseCalculoIcmsST() * calc.getIndiceAlteracaoST() - calc.getBaseCalculoIcmsST() * (calc.getValorDescontoPadraoST() / 100.0);
        bcSt = this.arrredondarNumero(bcSt, 2, params.getTipoArredondamento());
        Double valorSt = bcSt * (calc.getAliquotaIcmsST() / 100.0) - valorIcms;
        if (this.isAffirmative(params.getParamsCalcST().getCalcCreditoPresumidoST()).booleanValue()) {
            Double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsOrigemDestino();
            Double bc = this.getBCAbatendoSomentePisCofins(params);
            valorSt = valorSt - this.arrredondarNumero(bc * (aliquotaIcms / 100.0), 2, params.getTipoArredondamento());
        }
        if (valorSt < 0.0) {
            valorSt = 0.0;
        }
        calc.setBaseCalculoIcmsST(this.arrredondarNumero(bcSt, 2, params.getTipoArredondamento()));
        calc.setValorIcmsST(this.arrredondarNumero(valorSt, 2, params.getTipoArredondamento()));
    }

    protected void calcularIcmsDifalST(Double baseCalculo, Double valorIcms, IcmsParams params, IcmsCalculado calc) throws ExceptionImpostoIcms {
        if (this.isEquals(params.getParamsCalcST().getTipoTributacaoIcmsSt(), EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_NAO_INC_ICMSST).booleanValue()) {
            return;
        }
        if (this.isEquals(params.getParamsCalcST().getTipoTributacaoIcmsSt(), EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_DIFAL_BASE_DUPLA).booleanValue()) {
            this.calcDifalSTBaseDupla(baseCalculo, valorIcms, params, calc);
        } else if (this.isEquals(params.getParamsCalcST().getTipoTributacaoIcmsSt(), EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_DIFAL_BASE_SIMPLES).booleanValue()) {
            this.calcDifalSTBaseSimples(baseCalculo, params, calc);
        } else if (this.isEquals(params.getParamsCalcST().getTipoTributacaoIcmsSt(), EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_INFORMADA).booleanValue() || this.isEquals(params.getParamsCalcST().getTipoTributacaoIcmsSt(), EnumConstModFiscalDifalST.TIPO_TRIB_ICMSST_CAT_PRODUTO).booleanValue()) {
            this.calcularSt(params, calc);
        }
        this.calcularFCPStSaida(params, calc);
    }

    protected void calcularFCPStSaida(IcmsParams params, IcmsCalculado calc) {
        if (this.isEquals(params.getVersaoNFe(), EnumConstNFeVersao.VERSAO_4_00).booleanValue() && !this.isAffirmative(params.getNaoCalcularFCP()).booleanValue() && !this.isNull(calc.getBaseCalculoFCP()).booleanValue() && calc.getBaseCalculoFCP() > 0.0 && params.getParamsCalcIcms().getAliquotaFCP() > 0.0) {
            Double valorFCPSt = this.arrredondarNumero(calc.getBaseCalculoFCP() * (calc.getAliquotaFCP() / 100.0), 2, params.getTipoArredondamento());
            calc.setValorFCPST(valorFCPSt);
            calc.setAliquotaFCPST(calc.getAliquotaFCP());
            calc.setBaseCalculoFCPST(calc.getBaseCalculoFCP());
            calc.setValorFCP(0.0);
            calc.setAliquotaFCP(0.0);
            calc.setBaseCalculoFCP(0.0);
            calc.setValorFCPSTRetidos(0.0);
            calc.setAliquotaFCPSTRetido(0.0);
            calc.setBaseCalculoFCPSTRetido(0.0);
        }
    }

    private void calcDifalSTBaseSimples(Double baseCalculo, IcmsParams params, IcmsCalculado calc) throws ExceptionImpostoIcms {
        Double aliqIcms = params.getParamsCalcIcms().getAliquotaIcmsInformada();
        Double aliqInternaDest = TRulesIcms.getAliquotaInternaUFDestinatario(params);
        Double vrDifalST = this.calcIcms(baseCalculo, aliqInternaDest - aliqIcms, params.getTipoArredondamento());
        calc.setValorIcmsST(vrDifalST);
        calc.setBaseCalculoIcmsST(baseCalculo);
    }

    private void calcDifalSTBaseDupla(Double baseCalculo, Double valorIcms, IcmsParams params, IcmsCalculado calc) throws ExceptionImpostoIcms {
        Double aliqInternaDest = TRulesIcms.getAliquotaInternaUFDestinatario(params);
        Double bcDifalST = (baseCalculo - valorIcms) / (1.0 - aliqInternaDest / 100.0);
        Double vrDifalST = this.calcIcms(bcDifalST, aliqInternaDest, params.getTipoArredondamento());
        calc.setValorIcmsST(vrDifalST);
        calc.setBaseCalculoIcmsST(bcDifalST);
    }

    protected Double getAliquotaICMSST(IcmsParams params) {
        if (!this.isEquals(params.getUfDestino(), params.getUfOrigem()).booleanValue()) {
            return params.getParamsCalcIcms().getAliquotaIcmsOrigemDestino();
        }
        return params.getParamsCalcIcms().getAliquotaIcmsProduto();
    }
}

