/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculo;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;
import java.util.Arrays;
import java.util.List;

public class Icms00
extends BaseIcms
implements InterfaceIcmsCalculo {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsInformada();
        double vlrIcms = this.calcIcms(baseCalculo, aliquotaIcms, params.getTipoArredondamento());
        calc.setBaseCalculoIcms(baseCalculo);
        calc.setValorIcmsTributado(calc.getBaseCalculoIcms());
        calc.setValorIcms(vlrIcms);
        calc.setAliquotaIcms(aliquotaIcms);
        if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.ENTRADA) {
            if (!this.isRecuperaTributos(params)) {
                calc.setValorIcmsOutros(calc.getBaseCalculoIcms());
                calc.setValorIcmsSemAprov(vlrIcms);
                calc.setValorIcmsTributado(0.0);
                calc.setValorIcms(0.0);
            }
            this.calcularDiferencaAliquotaEntrada(params, calc);
        } else {
            this.calcularFCP(params, calc);
            this.calcPartilhaIcms(params, calc);
        }
        return calc;
    }

    @Override
    public List<EnumConstNFeIncidenciaIcms> getIncidencia() {
        return Arrays.asList(EnumConstNFeIncidenciaIcms.TRIBUTACAO_INTEGRALMENTE);
    }

    @Override
    public boolean validCalcEntrada() {
        return true;
    }

    @Override
    public boolean validCalcSaida() {
        return true;
    }
}

