/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl.saida;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculoImpl;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;

public class Icms20Saida
extends BaseIcms
implements InterfaceIcmsCalculoImpl {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBCCalculoReducao(params);
        double bcAcess = this.getBCDespAcessorias(params);
        double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsInformada();
        double vrReduz = this.calcIcms(baseCalculo, params.getParamsCalcIcms().getPercRedBCIcms(), params.getTipoArredondamento());
        calc.setValorIcmsTributado(this.arrredondarNumero(baseCalculo + bcAcess - vrReduz, 2, params.getTipoArredondamento()));
        calc.setValorIcmsIsento(this.arrredondarNumero(vrReduz, 2, params.getTipoArredondamento()));
        if (this.calcularValoresDesoneracao(params).booleanValue()) {
            calc.setValorIcmsDispensado(this.calcIcms(vrReduz, aliquotaIcms, params.getTipoArredondamento()));
            calc.setValorIcmsIsento(this.arrredondarNumero(vrReduz - calc.getValorIcmsDispensado(), 2, params.getTipoArredondamento()));
        }
        double vlrIcms = this.calcIcms(baseCalculo - vrReduz, aliquotaIcms, params.getTipoArredondamento()) + this.calcIcms(bcAcess, aliquotaIcms, params.getTipoArredondamento());
        calc.setValorIcms(vlrIcms);
        calc.setValorBCIcmsNaoTributado(vrReduz);
        calc.setAliquotaIcms(aliquotaIcms);
        calc.setBaseCalculoIcms(baseCalculo + bcAcess);
        this.calcularFCP(baseCalculo + bcAcess - vrReduz, params, calc);
        return calc;
    }

    @Override
    public EnumConstantsMentorEntSaida operacao() {
        return EnumConstantsMentorEntSaida.SAIDA;
    }

    @Override
    public EnumConstNFeIncidenciaIcms getIncidencia() {
        return EnumConstNFeIncidenciaIcms.COM_REDUCAO_BASE_CALCULO;
    }
}

