/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl.saida;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculoImpl;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;

public class Icms51Saida
extends BaseIcms
implements InterfaceIcmsCalculoImpl {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsInformada();
        Double percDiferimento = params.getParamsCalcIcms().getPercDiferimento();
        if (percDiferimento == 0.0) {
            calc.setBaseCalculoIcms(baseCalculo);
            calc.setAliquotaIcms(0.0);
            calc.setValorIcmsOutros(baseCalculo);
        } else {
            Double valorIcmsTotal = this.calcIcms(baseCalculo, aliquotaIcms, params.getTipoArredondamento());
            Double valorIcms = this.calcIcms(baseCalculo, aliquotaIcms, params.getTipoArredondamento());
            Double valorDiferimento = this.calcIcms(valorIcms, percDiferimento, params.getTipoArredondamento());
            valorIcms = valorIcms - valorDiferimento;
            Double percBaseCalculoTrib = 0.0;
            if (valorIcmsTotal > 0.0) {
                percBaseCalculoTrib = this.arrredondarNumero(valorIcms * 100.0 / valorIcmsTotal, 2, params.getTipoArredondamento());
            }
            Double baseCalculoTrib = this.arrredondarNumero(baseCalculo * (percBaseCalculoTrib / 100.0), 2, params.getTipoArredondamento());
            Double baseCalculoOutros = this.arrredondarNumero(baseCalculo - baseCalculoTrib, 2, params.getTipoArredondamento());
            calc.setBaseCalculoIcms(baseCalculo);
            calc.setValorIcmsTributado(baseCalculoTrib);
            calc.setValorIcmsOutros(baseCalculoOutros);
            calc.setAliquotaIcms(aliquotaIcms);
            calc.setPercentualDiferimento(percDiferimento);
            calc.setValorIcmsDiferido(valorDiferimento);
            if (params.getParamsCalcIcms().getAliquotaFCP() > 0.0) {
                calc.setValorFCP(this.arrredondarNumero(baseCalculo * (params.getParamsCalcIcms().getAliquotaFCP() / 100.0), 2, params.getTipoArredondamento()));
                calc.setAliquotaFCP(params.getParamsCalcIcms().getAliquotaFCP());
                calc.setBaseCalculoFCP(baseCalculo);
            }
        }
        return calc;
    }

    @Override
    public EnumConstantsMentorEntSaida operacao() {
        return EnumConstantsMentorEntSaida.SAIDA;
    }

    @Override
    public EnumConstNFeIncidenciaIcms getIncidencia() {
        return EnumConstNFeIncidenciaIcms.DIFERIMENTO;
    }
}

