/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl.saida;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcmsST;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculoImpl;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;

public class Icms70Saida
extends BaseIcmsST
implements InterfaceIcmsCalculoImpl {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        double bcAcess = this.getBCDespAcessorias(params);
        double aliquotaICMS = params.getParamsCalcIcms().getAliquotaIcmsInformada();
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirDespAcessCalcRed()).booleanValue()) {
            baseCalculo += bcAcess;
            bcAcess = 0.0;
        }
        double vrReduz = this.arrredondarNumero(baseCalculo * (params.getParamsCalcIcms().getPercRedBCIcms() / 100.0), 2, params.getTipoArredondamento());
        double vlrIcms = 0.0;
        calc.setValorIcmsTributado(this.arrredondarNumero(baseCalculo + bcAcess - vrReduz, 2, params.getTipoArredondamento()));
        calc.setBaseCalculoIcms(baseCalculo + bcAcess);
        calc.setValorIcmsIsento(vrReduz);
        if (!this.isEquals(params.getParamsCalcIcms().getTipoAliquotaIcms(), EnumConstTipoAliquotaIcms.ALIQ_ICMS_SEM_INCIDENCIA).booleanValue()) {
            vlrIcms = this.arrredondarNumero((baseCalculo - vrReduz) * (aliquotaICMS / 100.0), 2, params.getTipoArredondamento()) + this.arrredondarNumero(bcAcess * (aliquotaICMS / 100.0), 2, params.getTipoArredondamento());
            calc.setValorIcms(vlrIcms);
            calc.setValorBCIcmsNaoTributado(vrReduz);
            if (this.calcularValoresDesoneracao(params).booleanValue()) {
                double valorIcmsDesonerado = this.arrredondarNumero(vrReduz * (aliquotaICMS / 100.0), 2, params.getTipoArredondamento());
                double valorIcmsIsento = vrReduz - valorIcmsDesonerado;
                calc.setValorIcmsDispensado(valorIcmsDesonerado);
                calc.setValorIcmsIsento(valorIcmsIsento);
            }
            calc.setAliquotaIcms(aliquotaICMS);
        } else {
            vlrIcms = this.calcIcms(baseCalculo, aliquotaICMS, params.getTipoArredondamento());
            if (this.icmsDescontadoValorTotalNota(params).booleanValue()) {
                double valorIcmsDesonerado = vlrIcms;
                double valorIcmsIsento = this.arrredondarNumero(baseCalculo - valorIcmsDesonerado, 2, params.getTipoArredondamento());
                calc.setValorIcmsDispensado(valorIcmsDesonerado);
                calc.setValorIcmsIsento(valorIcmsIsento);
                calc.setAliquotaIcms(aliquotaICMS);
            } else {
                calc.setAliquotaIcms(0.0);
            }
        }
        this.calcularFCP(baseCalculo + bcAcess - vrReduz, params, calc);
        this.calcularIcmsDifalST(params.getValorProdServ(), vlrIcms, params, calc);
        return calc;
    }

    @Override
    public EnumConstantsMentorEntSaida operacao() {
        return EnumConstantsMentorEntSaida.SAIDA;
    }

    @Override
    public EnumConstNFeIncidenciaIcms getIncidencia() {
        return EnumConstNFeIncidenciaIcms.COM_REDUCAO_BASE_CALCULO_COBRANCA_ICMS_POR_SUBSTITUICAO_TRIBUTARIA_ICMS_SUBSTITUICAO_TRIBUTARIA;
    }
}

