/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl.saida;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcmsST;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculoImpl;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;

public class Icms900Saida
extends BaseIcmsST
implements InterfaceIcmsCalculoImpl {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        double baseCalculo = this.getBC(params);
        double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsInformada();
        calc.setBaseCalculoIcms(baseCalculo);
        calc.setValorIcmsOutros(baseCalculo);
        if (this.isAffirmative(params.getParamsCalcIcms().getCalcularIcmsSimples()).booleanValue()) {
            calc.setAliquotaIcmsSimples(params.getParamsCalcIcms().getAliquotaIcmsSimples());
            calc.setValorIcmsSimples(this.calcIcms(baseCalculo, params.getParamsCalcIcms().getAliquotaIcmsSimples(), params.getTipoArredondamento()));
        } else {
            calc.setAliquotaIcmsSimples(0.0);
            calc.setValorIcmsSimples(0.0);
        }
        calc.setAliquotaIcms(0.0);
        double bcAcess = this.getBCDespAcessorias(params);
        if (this.isAffirmative(params.getParamsCalcIcms().getIncluirDespAcessCalcRed()).booleanValue()) {
            baseCalculo += bcAcess;
            bcAcess = 0.0;
        }
        double vlrIcms = 0.0;
        if (!this.isEquals(params.getParamsCalcIcms().getTipoAliquotaIcms(), EnumConstTipoAliquotaIcms.ALIQ_ICMS_SEM_INCIDENCIA).booleanValue()) {
            if (!this.isNull(params.getParamsCalcIcms().getPercRedBCIcms()).booleanValue() && params.getParamsCalcIcms().getPercRedBCIcms() > 0.0) {
                double vrReduz = this.arrredondarNumero(baseCalculo * (params.getParamsCalcIcms().getPercRedBCIcms() / 100.0), 2, params.getTipoArredondamento());
                calc.setValorIcmsOutros(baseCalculo + bcAcess);
                calc.setBaseCalculoIcms(baseCalculo + bcAcess);
                vlrIcms = this.arrredondarNumero((baseCalculo - vrReduz) * (aliquotaIcms / 100.0), 2, params.getTipoArredondamento()) + this.arrredondarNumero(bcAcess * (aliquotaIcms / 100.0), 2, params.getTipoArredondamento());
                calc.setValorIcms(vlrIcms);
                calc.setValorBCIcmsNaoTributado(vrReduz);
                if (this.calcularValoresDesoneracao(params).booleanValue()) {
                    Double valorIcmsDesonerado = this.calcIcms(vrReduz, aliquotaIcms, params.getTipoArredondamento());
                    calc.setValorIcmsDispensado(valorIcmsDesonerado);
                }
                calc.setAliquotaIcms(aliquotaIcms);
            } else {
                vlrIcms = this.calcIcms(baseCalculo, aliquotaIcms, params.getTipoArredondamento());
                calc.setValorIcmsOutros(baseCalculo);
                calc.setBaseCalculoIcms(baseCalculo);
                calc.setValorIcms(vlrIcms);
                calc.setAliquotaIcms(aliquotaIcms);
            }
        } else {
            calc.setBaseCalculoIcms(baseCalculo);
            calc.setValorIcmsOutros(baseCalculo);
            calc.setAliquotaIcms(0.0);
            calc.setValorIcms(0.0);
            calc.setPercentualRedBC(0.0);
        }
        aliquotaIcms = this.getAliquotaICMSST(params);
        Double valorIcms = this.calcIcms(baseCalculo, aliquotaIcms, params.getTipoArredondamento());
        this.calcularIcmsDifalST(baseCalculo + params.getValorDesconto(), valorIcms, params, calc);
        return calc;
    }

    @Override
    public EnumConstantsMentorEntSaida operacao() {
        return EnumConstantsMentorEntSaida.SAIDA;
    }

    @Override
    public EnumConstNFeIncidenciaIcms getIncidencia() {
        return EnumConstNFeIncidenciaIcms.SIMPLES_OUTROS;
    }
}

