/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.icms.impl.saida;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstNFeIncidenciaIcms;
import com.touchcomp.basementor.constants.enums.impostos.icms.EnumConstTipoAliquotaIcms;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoicms.ExceptionImpostoIcms;
import com.touchcomp.basementorrules.impostos.icms.impl.BaseIcmsST;
import com.touchcomp.basementorrules.impostos.icms.impl.Icms00;
import com.touchcomp.basementorrules.impostos.icms.impl.InterfaceIcmsCalculoImpl;
import com.touchcomp.basementorrules.impostos.icms.impl.saida.Icms20Saida;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsCalculado;
import com.touchcomp.basementorrules.impostos.icms.model.IcmsParams;

public class Icms90Saida
extends BaseIcmsST
implements InterfaceIcmsCalculoImpl {
    @Override
    public IcmsCalculado calcular(IcmsParams params) throws ExceptionImpostoIcms {
        IcmsCalculado calc = new IcmsCalculado(params);
        if (this.isEquals(params.getParamsCalcIcms().getTipoAliquotaIcms(), EnumConstTipoAliquotaIcms.ALIQ_ICMS_SEM_INCIDENCIA).booleanValue()) {
            if (params.getParamsCalcIcms().getPercRedBCIcms() > 0.0) {
                Icms20Saida icms20 = new Icms20Saida();
                calc = icms20.calcular(params);
            } else {
                Icms00 icms00 = new Icms00();
                calc = icms00.calcular(params);
            }
        } else {
            double baseCalculo = this.getBC(params);
            double aliquotaIcms = params.getParamsCalcIcms().getAliquotaIcmsInformada();
            double vlrIcms = this.calcIcms(baseCalculo, aliquotaIcms, params.getTipoArredondamento());
            calc.setBaseCalculoIcms(baseCalculo);
            calc.setValorIcmsOutros(baseCalculo);
            if (this.icmsDescontadoValorTotalNota(params).booleanValue()) {
                Double valorIcmsDesonerado = vlrIcms;
                Double vlrIcmsOutros = this.arrredondarNumero(baseCalculo - valorIcmsDesonerado, 2, params.getTipoArredondamento());
                calc.setValorIcmsDispensado(valorIcmsDesonerado);
                calc.setValorIcmsOutros(vlrIcmsOutros);
                calc.setAliquotaIcms(aliquotaIcms);
            } else {
                calc.setAliquotaIcms(0.0);
            }
        }
        this.calcularIcmsDifalST(calc.getBaseCalculoIcms(), calc.getValorIcms(), params, calc);
        return calc;
    }

    @Override
    public EnumConstantsMentorEntSaida operacao() {
        return EnumConstantsMentorEntSaida.SAIDA;
    }

    @Override
    public EnumConstNFeIncidenciaIcms getIncidencia() {
        return EnumConstNFeIncidenciaIcms.OUTROS;
    }
}

