/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.ipi;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.ipi.EnumConstNFeIncidenciaIpi;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.EnumExcepImpostoIpi;
import com.touchcomp.basementorexceptions.exceptions.impl.impostoipi.ExceptionImpostoIPI;
import com.touchcomp.basementorrules.impostos.ipi.impl.InterfaceIPICalculo;
import com.touchcomp.basementorrules.impostos.ipi.model.IPICalculado;
import com.touchcomp.basementorrules.impostos.ipi.model.IPIParams;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.util.Iterator;
import java.util.List;

public class CompImpostoIPI {
    public static IPICalculado calcularIpi(IPIParams params) throws ExceptionImpostoIPI {
        try {
            List listeners = ToolReflections.getClassesFromInterface((String)InterfaceIPICalculo.class.getPackage().getName(), InterfaceIPICalculo.class);
            InterfaceIPICalculo found = CompImpostoIPI.filter(listeners, params);
            if (found == null) {
                System.out.println("\n\nIncidencia de IPI  nao suportada " + String.valueOf(params.getIncidenciaIpi()));
                throw new ExceptionImpostoIPI(EnumExcepImpostoIpi.INCIDENCIA_NAO_MAPEADA_CALC, new Object[]{params.getIncidenciaIpi()});
            }
            if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.ENTRADA && !found.validCalcEntrada()) {
                throw new ExceptionImpostoIPI(EnumExcepImpostoIpi.INCIDENCIA_INVALIDA_ENTRADA, new Object[]{params.getIncidenciaIpi()});
            }
            if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.SAIDA && !found.validCalcSaida()) {
                throw new ExceptionImpostoIPI(EnumExcepImpostoIpi.INCIDENCIA_INVALIDA_SAIDA, new Object[]{params.getIncidenciaIpi()});
            }
            IPICalculado ipiCalc = found.calcular(params);
            ipiCalc.setAliquotaIpi(params.getAliquotaIPI());
            return ipiCalc;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new ExceptionErroProgramacao(e.getMessage(), (Throwable)e);
        }
    }

    private static InterfaceIPICalculo filter(List<Class> listeners, IPIParams params) throws InstantiationException, IllegalAccessException {
        InterfaceIPICalculo found = null;
        Iterator<Class> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            Class clazz;
            Class clazzCalc = clazz = iterator.next();
            InterfaceIPICalculo calc = (InterfaceIPICalculo)clazzCalc.newInstance();
            String codigo = params.getIncidenciaIpi().getCodigo();
            EnumConstNFeIncidenciaIpi inc = EnumConstNFeIncidenciaIpi.valueOfCodigo((String)codigo);
            if (!calc.getIncidencia().contains(inc)) continue;
            return calc;
        }
        return found;
    }

    public static Double getAliquotaIpi(Double aliqIpiProduto, Double aliqIpiModelo, Short tipoAliq) {
        Double aliqIpi = 0.0;
        aliqIpi = tipoAliq == 2 ? aliqIpiModelo : aliqIpiProduto;
        if (aliqIpi == null) {
            aliqIpi = 0.0;
        }
        return aliqIpi;
    }
}

