/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostos.piscofins;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.impostos.piscofins.EnumConstNFeIncidenciaCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.EnumExcepImpostoPisCofins;
import com.touchcomp.basementorexceptions.exceptions.impl.impostopiscofins.ExceptionImpostoPisCofins;
import com.touchcomp.basementorrules.impostos.piscofins.impl.InterfacePisCofinsCalculo;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsCalculado;
import com.touchcomp.basementorrules.impostos.piscofins.model.PisCofinsParams;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.util.Iterator;
import java.util.List;

public class CompImpostoPisCofins {
    public static PisCofinsCalculado calcularPisCofins(PisCofinsParams params) throws ExceptionImpostoPisCofins {
        try {
            List listeners = ToolReflections.getClassesFromInterface((String)InterfacePisCofinsCalculo.class.getPackage().getName(), InterfacePisCofinsCalculo.class);
            InterfacePisCofinsCalculo found = CompImpostoPisCofins.filter(listeners, params);
            if (found == null) {
                throw new ExceptionImpostoPisCofins(EnumExcepImpostoPisCofins.INCIDENCIA_NAO_MAPEADA_CALC, new Object[]{params.getIncidenciaPisCofins()});
            }
            if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.ENTRADA && !found.validCalcEntrada()) {
                throw new ExceptionImpostoPisCofins(EnumExcepImpostoPisCofins.INCIDENCIA_INVALIDA_ENTRADA, new Object[]{params.getIncidenciaPisCofins()});
            }
            if (params.getEntradaSaida() == EnumConstantsMentorEntSaida.SAIDA && !found.validCalcSaida()) {
                throw new ExceptionImpostoPisCofins(EnumExcepImpostoPisCofins.INCIDENCIA_INVALIDA_SAIDA, new Object[]{params.getIncidenciaPisCofins()});
            }
            return found.calcular(params);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new ExceptionErroProgramacao(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ExceptionErroProgramacao(e.getMessage(), (Throwable)e);
        }
    }

    private static InterfacePisCofinsCalculo filter(List<Class> listeners, PisCofinsParams params) throws InstantiationException, IllegalAccessException {
        InterfacePisCofinsCalculo found = null;
        Iterator<Class> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            Class clazz;
            Class clazzCalc = clazz = iterator.next();
            InterfacePisCofinsCalculo calc = (InterfacePisCofinsCalculo)clazzCalc.newInstance();
            String codigo = params.getIncidenciaPisCofins().getCodigo();
            EnumConstNFeIncidenciaCofins inc = EnumConstNFeIncidenciaCofins.valueOfCodigo((String)codigo);
            if (!calc.getIncidencia().contains(inc)) continue;
            return calc;
        }
        return found;
    }
}

