/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostosfolha.inss;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInss;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInssParams;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;

class AuxBCInss {
    AuxBCInss() {
    }

    public BaseCalcInss calcularBcInss(BaseCalcInss base, BaseCalcInssParams params) {
        EnumConstTipoCalculoEvento tipoCalc = params.getTipoFolha();
        this.calcularBases(tipoCalc, params, base);
        this.calcularOutrosVinculos(params, base);
        base.setBcInssSalario(base.getBcInssSalario() + params.getBaseInssRecisao());
        base.setBcInssSalario(base.getBcInssSalario() + base.getBcInssSalarioProvento() - base.getBcInssSalarioDesconto());
        base.setBcInssFerias(base.getBcInssFerias() + base.getBcInssFeriasProvento() - base.getBcInssFeriasDesconto());
        base.setBcInss13Salario(base.getBcInss13Salario() + base.getBcInss13SalProvento() - base.getBcInss13SalDesconto());
        base.setVrInssFerias(base.getVrInssFerias() + params.getVrInssFerias());
        base.setVrInss13Salario(base.getVrInss13Salario() + params.getVrInss13Sal());
        base.setVrInssSalario(base.getVrInssSalario() + params.getVrInssSalario());
        this.ajustarBaseCalculoTabela(params, base);
        return base;
    }

    private void calcularBases(EnumConstTipoCalculoEvento tipoCalc, BaseCalcInssParams m, BaseCalcInss base) {
        switch (tipoCalc) {
            case CALCULO_ADIANTAMENTO_13O: {
                this.calcularBases13(m, base);
                break;
            }
            case CALCULO_DEC_13O: {
                this.calcularBases13(m, base);
                break;
            }
            case CALCULO_FOLHA_COMPLEMENTAR_DEC: {
                this.calcularBases13(m, base);
                break;
            }
            case CALCULO_FOLHA_DE_PAGAMENTO: {
                this.calcularFolha(m, base);
                break;
            }
            case CALCULO_FOLHA_COMPLEMENTAR: {
                this.calcularFolha(m, base);
                break;
            }
            case CALCULO_ADIANTAMENTO_SALARIO: {
                break;
            }
            case CALCULO_FERIAS: {
                this.calcularFerias(m, base);
                break;
            }
            case CALCULO_RECISAO_COMPLEMENTAR: {
                break;
            }
            case CALCULO_RESCISAO: {
                break;
            }
            default: {
                throw new ExceptionErroProgramacao("tipo calculo nao mapeado: " + String.valueOf(tipoCalc));
            }
        }
    }

    private void calcularBases13(BaseCalcInssParams m, BaseCalcInss base) {
        for (BaseCalcInssParams.ItemMovimento itemMov : m.getItensMovimento()) {
            Short incInss = itemMov.getIncidenciaInss();
            EnumConstEventoParamFolha tipoEvento = itemMov.getTipoEventoProvDesc();
            if (!TMethods.isAffirmative((Number)incInss)) continue;
            if (TMethods.isEquals((Object)tipoEvento, (Object)EnumConstEventoParamFolha.EVENTO_PROVENTO)) {
                base.setBcInss13SalProvento(base.getBcInss13SalProvento() + itemMov.getValorMovimento());
                continue;
            }
            base.setBcInss13SalDesconto(base.getBcInss13SalDesconto() + itemMov.getValorMovimento());
        }
    }

    private void calcularFerias(BaseCalcInssParams m, BaseCalcInss base) {
        for (BaseCalcInssParams.ItemMovimento itemMov : m.getItensMovimento()) {
            Short incInss = itemMov.getIncidenciaInss();
            EnumConstEventoParamFolha tipoEvento = itemMov.getTipoEventoProvDesc();
            if (!TMethods.isAffirmative((Number)incInss)) continue;
            if (TMethods.isEquals((Object)tipoEvento, (Object)EnumConstEventoParamFolha.EVENTO_PROVENTO)) {
                base.setBcInssFeriasProvento(base.getBcInssFeriasProvento() + itemMov.getValorMovimento());
                continue;
            }
            base.setBcInssFeriasDesconto(base.getBcInssFeriasDesconto() + itemMov.getValorMovimento());
        }
    }

    private void calcularFolha(BaseCalcInssParams m, BaseCalcInss base) {
        for (BaseCalcInssParams.ItemMovimento itemMov : m.getItensMovimento()) {
            Short incInss = itemMov.getIncidenciaInss();
            EnumConstEventoParamFolha tipoEvento = itemMov.getTipoEventoProvDesc();
            if (!TMethods.isAffirmative((Number)incInss)) continue;
            if (TMethods.isEquals((Object)tipoEvento, (Object)EnumConstEventoParamFolha.EVENTO_PROVENTO)) {
                base.setBcInssSalarioProvento(base.getBcInssSalarioProvento() + itemMov.getValorMovimento());
                continue;
            }
            base.setBcInssSalarioDesconto(base.getBcInssSalarioDesconto() + itemMov.getValorMovimento());
        }
    }

    private void ajustarBaseCalculoTabela(BaseCalcInssParams params, BaseCalcInss base) {
        base.setBcInssSalario(base.getBcInssSalarioProvento() - base.getBcInssSalarioDesconto());
        base.setBcInssFerias(base.getBcInssFeriasProvento() - base.getBcInssFeriasDesconto());
        base.setBcInss13Salario(base.getBcInss13SalProvento() - base.getBcInss13SalDesconto());
        base.setBcSalarioCalc(base.getBcInssSalario());
        base.setBcFeriasCalc(base.getBcInssFerias());
        if (params.getTipoColaborador() == EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()) {
            base.setBcSalarioCalc(base.getBcInssSalario() * (params.getPercBcFreteInssAutonomo() / 100.0));
            base.setBcFeriasCalc(0.0);
        } else if (base.getBcInssSalario() + base.getBcInssOutrosVinculos() > params.getVrLimiteMaximoInss()) {
            base.setBcSalarioCalc(params.getVrLimiteMaximoInss() - base.getBcInssOutrosVinculos());
            base.setBcFeriasCalc(0.0);
        } else if (base.getBcInssFerias() + base.getBcInssOutrosVinculos() > params.getVrLimiteMaximoInss()) {
            base.setBcFeriasCalc(params.getVrLimiteMaximoInss() - base.getBcInssOutrosVinculos());
            base.setBcSalarioCalc(0.0);
        } else if (base.getBcInssFerias() + base.getBcInssSalario() + base.getBcInssOutrosVinculos() > params.getVrLimiteMaximoInss()) {
            base.setBcInssSalario(params.getVrLimiteMaximoInss() - base.getBcInssFerias() - base.getBcInssOutrosVinculos());
        }
        base.setBcSalarioCalc(ToolFormatter.arrredondarNumero((Double)base.getBcSalarioCalc(), (int)2));
        base.setBcFeriasCalc(ToolFormatter.arrredondarNumero((Double)base.getBcFeriasCalc(), (int)2));
    }

    private void calcularOutrosVinculos(BaseCalcInssParams vo, BaseCalcInss base) {
        double baseOutrosVinc = 0.0;
        for (BaseCalcInssParams.MultiplosVinculosEmpregaticios m : vo.getMultiplosVinculosEmpregaticios()) {
            baseOutrosVinc += m.getValorRemuneracaoRecebida().doubleValue();
        }
        base.setBcInssOutrosVinculos(baseOutrosVinc);
    }
}

