/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostosfolha.inss;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInss;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInssParams;
import com.touchcomp.basementortools.tools.methods.TMethods;

public class AuxCalcInssEmpresa {
    void calcularInss(BaseCalcInssParams params, BaseCalcInss valores) {
        Double baseProvento = 0.0;
        Double baseDesconto = 0.0;
        Double baseProventoDec = 0.0;
        Double baseDescontoDec = 0.0;
        for (BaseCalcInssParams.ItemMovimento i : params.getItensMovimento()) {
            Short incIcms = i.getIncidenciaInss();
            EnumConstEventoParamFolha tipoEvento = i.getTipoEventoProvDesc();
            if (!TMethods.isAffirmative((Number)incIcms) || !TMethods.isStrWithData((String)i.getCodigoEsocRubricaPrevidencia())) continue;
            String codRub = i.getCodigoEsocRubricaPrevidencia();
            if (TMethods.isEquals((Object)tipoEvento, (Object)EnumConstEventoParamFolha.EVENTO_PROVENTO)) {
                if (TMethods.isEquals((Object)codRub, (Object)"11")) {
                    baseProvento = baseProvento + i.getValorMovimento();
                }
                if (!TMethods.isEquals((Object)codRub, (Object)"12")) continue;
                baseProventoDec = baseProventoDec + i.getValorMovimento();
                continue;
            }
            if (!TMethods.isEquals((Object)tipoEvento, (Object)EnumConstEventoParamFolha.EVENTO_DESCONTO)) continue;
            if (TMethods.isEquals((Object)codRub, (Object)"11")) {
                baseDesconto = baseDesconto + i.getValorMovimento();
                continue;
            }
            if (!TMethods.isEquals((Object)codRub, (Object)"12")) continue;
            baseDescontoDec = baseDescontoDec + i.getValorMovimento();
        }
        Double baseNormal = baseProvento - baseDesconto;
        Double baseDec = baseProventoDec - baseDescontoDec;
        if (baseNormal < 0.0) {
            baseNormal = 0.0;
        }
        if (baseDec < 0.0) {
            baseDec = 0.0;
        }
        valores.setBcEmpresaColaborador(baseNormal + baseDec);
    }
}

