/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostosfolha.inss;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementorrules.impostosfolha.inss.AuxAliquotaInss;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInss;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInssParams;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.LinkedList;

public class AuxCalcInssEscalonado {
    void calcularInss(BaseCalcInss valores, BaseCalcInssParams params) {
        Long tipoColaborador = params.getTipoColaborador();
        valores.setVrInss13Salario(0.0);
        valores.setVrInssFerias(0.0);
        valores.setVrInssSalario(0.0);
        valores.setAliqInss13Sal(0.0);
        valores.setAliqInssFerias(0.0);
        valores.setAliqInssSalario(0.0);
        valores.getBasesEscalonadas().clear();
        if (TMethods.isAnyEquals((Object[])new Object[]{tipoColaborador, EnumConstTipoColaborador.EMPREGADO.getValue(), EnumConstTipoColaborador.MENOR_APRENDIZ.getValue(), EnumConstTipoColaborador.DOMESTICO.getValue(), EnumConstTipoColaborador.RURAL.getValue()})) {
            this.calcularInssBaseVariada(params, valores);
            return;
        }
        if (TMethods.isAnyEquals((Object[])new Object[]{tipoColaborador, EnumConstTipoColaborador.AUTONOMO.getValue(), EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()})) {
            double aliquota = new AuxAliquotaInss().getAliquotaMaior(params);
            this.calcularInssBaseUnica(aliquota, params, valores);
            return;
        }
        if (TMethods.isAnyEquals((Object[])new Object[]{tipoColaborador, EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()})) {
            double aliquota = new AuxAliquotaInss().getAliquotaMaior(params);
            this.calcularInssBaseUnica(aliquota, params, valores);
            return;
        }
    }

    private void calcularInssBaseUnica(double aliquotaInss, BaseCalcInssParams params, BaseCalcInss valores) {
        valores.setBcInssFerias(0.0);
        valores.setAliqInssFerias(0.0);
        valores.setVrInssFerias(0.0);
        valores.setBcInssSalario(valores.getBcInssSalario());
        valores.setAliqInssSalario(aliquotaInss);
        valores.setVrInssSalario(this.getTruncarInss(valores.getBcSalarioCalc() * aliquotaInss / 100.0 - valores.getVrInssSalario()));
        this.novaBaseInssCalc(valores.getBcSalarioCalc(), aliquotaInss, valores.getVrInssSalario(), valores);
    }

    private void calcularInssBaseVariada(BaseCalcInssParams params, BaseCalcInss valores) {
        if (valores.getBcInssSalario() == 0.0) {
            double aliquotaMedia = this.calcularEscalonado(valores.getBcFeriasCalc(), params, valores);
            valores.setBcInssSalario(0.0);
            valores.setAliqInssSalario(0.0);
            valores.setVrInssSalario(0.0);
            valores.setBcInssFerias(valores.getBcFeriasCalc());
            valores.setVrInssFerias(this.getTotal(valores));
            valores.setAliqInssFerias(aliquotaMedia);
        } else if (valores.getBcInssFerias() == 0.0) {
            double aliquotaMedia = this.calcularEscalonado(valores.getBcSalarioCalc(), params, valores);
            valores.setBcInssFerias(0.0);
            valores.setAliqInssFerias(0.0);
            valores.setVrInssFerias(0.0);
            valores.setBcInssSalario(valores.getBcSalarioCalc());
            valores.setAliqInssSalario(aliquotaMedia);
            valores.setVrInssSalario(this.getTotal(valores));
        } else {
            Double bcInssTotal = this.getTruncarInss(valores.getBcFeriasCalc() + valores.getBcSalarioCalc());
            double aliquotaMedia = this.calcularEscalonado(bcInssTotal, params, valores);
            valores.setBcInssFerias(valores.getBcFeriasCalc());
            valores.setBcInssSalario(valores.getBcSalarioCalc());
            valores.setVrInssSalario(this.getTotal(valores));
            valores.setAliqInssSalario(aliquotaMedia);
            valores.setAliqInssFerias(aliquotaMedia);
            Double aliquotaCalculadaFerias = AuxCalcInssEscalonado.getAliquotaMediaFerias(params);
            Double vrInssFerias = valores.getVrInssFerias();
            Double vrInssSalario = valores.getVrInssSalario();
            Double valorInss = valores.getVrInssSalario();
            if (aliquotaCalculadaFerias == 0.0) {
                valores.setVrInssSalario(this.getTruncarInss(valores.getBcSalarioCalc() * aliquotaMedia / 100.0) - (vrInssFerias + vrInssSalario));
                valores.setVrInssFerias(ToolFormatter.arrredondarNumero((Double)(valorInss - valores.getVrInssSalario()), (int)2));
            } else {
                Double inssFerias = this.getTruncarInss(valores.getBcFeriasCalc() * aliquotaCalculadaFerias / 100.0) - (vrInssFerias + vrInssSalario);
                if (inssFerias <= valorInss) {
                    valores.setVrInssFerias(inssFerias);
                    valores.setVrInssSalario(ToolFormatter.arrredondarNumero((Double)(valorInss - inssFerias), (int)2));
                } else {
                    valores.setVrInssFerias(valorInss);
                    valores.setVrInssSalario(0.0);
                }
            }
        }
    }

    private Double getTruncarInss(double valor) {
        BigDecimal bd = BigDecimal.valueOf(valor);
        bd = bd.setScale(2, RoundingMode.DOWN);
        return bd.doubleValue();
    }

    private void novaBaseInssCalc(Double bcSalarioCalc, double aliquotaInss, Double vrInss, BaseCalcInss vo) {
        BaseCalcInss.BaseInssEscalonada base = new BaseCalcInss.BaseInssEscalonada("FOLHA");
        base.setBaseInss(bcSalarioCalc);
        base.setAliquota(aliquotaInss);
        base.setValor(vrInss);
        vo.getBasesEscalonadas().add(base);
    }

    private double calcularEscalonado(Double bcInss, BaseCalcInssParams params, BaseCalcInss vo) {
        LinkedList<BaseCalcInssParams.ItemTabelaInss> itens = new LinkedList<BaseCalcInssParams.ItemTabelaInss>(params.getItensTabelaInss());
        Collections.sort(itens, (i1, i2) -> i1.getIndice().compareTo(i2.getIndice()));
        double valorTotalInss = 0.0;
        double valorBCInss = bcInss;
        BaseCalcInssParams.ItemTabelaInss itemAnt = null;
        while (bcInss > 0.0 && !itens.isEmpty()) {
            Double valorbc;
            BaseCalcInssParams.ItemTabelaInss item = (BaseCalcInssParams.ItemTabelaInss)itens.remove(0);
            Double aliquota = item.getAliquotaInss();
            Double valorFaixa = item.getValorAte();
            if (itemAnt != null) {
                valorFaixa = item.getValorAte() - itemAnt.getValorAte();
            }
            if (bcInss < valorFaixa) {
                valorbc = bcInss;
                bcInss = 0.0;
            } else {
                valorbc = valorFaixa;
                bcInss = bcInss - valorFaixa;
            }
            itemAnt = item;
            Double valorinss = this.getTruncarInss(valorbc * aliquota / 100.0);
            this.novaBaseInssCalc(valorbc, aliquota, valorinss, vo);
            valorTotalInss += valorinss.doubleValue();
        }
        return ToolNumber.calcPercentual((Double)valorTotalInss, (Double)valorBCInss);
    }

    private static Double getAliquotaMediaFerias(BaseCalcInssParams vo) {
        for (BaseCalcInssParams.ItemMovimento i : vo.getItensMovimento()) {
            if (!ToolMethods.isAffirmative((Number)i.getPossuiFerias())) continue;
            return vo.getVrInssFerias() / vo.getBcInssFerias() * 100.0;
        }
        return 0.0;
    }

    private Double getTotal(BaseCalcInss valores) {
        return valores.getBasesEscalonadas().stream().mapToDouble(i -> i.getValor()).sum();
    }
}

