/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostosfolha.inss;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorrules.impostosfolha.inss.AuxAliquotaInss;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInss;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInssParams;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.math.BigDecimal;
import java.math.RoundingMode;

class AuxCalcInssNormal {
    AuxAliquotaInss auxAliquotaInss = new AuxAliquotaInss();

    void calcularInss(BaseCalcInssParams params, BaseCalcInss valores) {
        Long tipoColaborador = params.getTipoColaborador();
        Double bcTotal = valores.getBcFeriasCalc() + valores.getBcSalarioCalc();
        if (TMethods.isAnyEquals((Object[])new Object[]{tipoColaborador, EnumConstTipoColaborador.EMPREGADO.getValue(), EnumConstTipoColaborador.MENOR_APRENDIZ.getValue(), EnumConstTipoColaborador.DOMESTICO.getValue(), EnumConstTipoColaborador.RURAL.getValue()})) {
            double aliquota = this.auxAliquotaInss.getAliquotaIndice(bcTotal, params);
            this.calcularInss(aliquota, params, valores);
            return;
        }
        if (TMethods.isAnyEquals((Object[])new Object[]{tipoColaborador, EnumConstTipoColaborador.AUTONOMO.getValue(), EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()})) {
            double aliquota = new AuxAliquotaInss().getAliquotaMaior(params);
            this.calcularInss(aliquota, params, valores);
            return;
        }
        if (TMethods.isAnyEquals((Object[])new Object[]{tipoColaborador, EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()})) {
            double aliquota = new AuxAliquotaInss().getAliquotaMaior(params);
            this.calcularInss(aliquota, params, valores);
            return;
        }
        throw new ExceptionErroProgramacao("nenhuma aliquota de inss encontrada para " + bcTotal + " tabela " + String.valueOf(params) + " tipo colaborador" + tipoColaborador);
    }

    private void calcularInss(double aliquotaInss, BaseCalcInssParams params, BaseCalcInss vo) {
        if (vo.getBcInssSalario() == 0.0) {
            vo.setBcInssSalario(0.0);
            vo.setAliqInssSalario(0.0);
            vo.setVrInssSalario(0.0);
            vo.setBcInssFerias(vo.getBcInssFerias());
            vo.setAliqInssFerias(aliquotaInss);
            vo.setVrInssFerias(this.getTruncarInss(vo.getBcFeriasCalc() * aliquotaInss / 100.0 - vo.getVrInssFerias()));
        } else if (vo.getBcInssFerias() == 0.0) {
            vo.setBcInssFerias(0.0);
            vo.setAliqInssFerias(0.0);
            vo.setVrInssFerias(0.0);
            vo.setBcInssSalario(vo.getBcInssSalario());
            vo.setAliqInssSalario(aliquotaInss);
            vo.setVrInssSalario(this.getTruncarInss(vo.getBcSalarioCalc() * aliquotaInss / 100.0 - vo.getVrInssSalario()));
        } else {
            Double bcInssTotalCalc = this.getTruncarInss((vo.getBcFeriasCalc() + vo.getBcSalarioCalc()) * (aliquotaInss / 100.0));
            vo.setBcInssFerias(vo.getBcInssFerias());
            vo.setAliqInssFerias(aliquotaInss);
            vo.setVrInssFerias(this.getTruncarInss(vo.getBcFeriasCalc() * (aliquotaInss / 100.0)));
            vo.setBcInssSalario(vo.getBcInssSalario());
            vo.setAliqInssSalario(aliquotaInss);
            vo.setVrInssSalario(ToolFormatter.arrredondarNumero((Double)(bcInssTotalCalc - vo.getVrInssFerias()), (int)2));
        }
    }

    private Double getTruncarInss(Double valor) {
        BigDecimal bd = BigDecimal.valueOf(valor);
        bd = bd.setScale(2, RoundingMode.DOWN);
        return bd.doubleValue();
    }
}

