/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.impostosfolha.inss;

import com.touchcomp.basementor.constants.enums.tabelainss.EnumConstTipoCalcTabelaInss;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorrules.impostosfolha.inss.AuxBCInss;
import com.touchcomp.basementorrules.impostosfolha.inss.AuxCalcInssEmpresa;
import com.touchcomp.basementorrules.impostosfolha.inss.AuxCalcInssEscalonado;
import com.touchcomp.basementorrules.impostosfolha.inss.AuxCalcInssNormal;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInss;
import com.touchcomp.basementorrules.impostosfolha.inss.model.BaseCalcInssParams;
import com.touchcomp.basementortools.tools.methods.TMethods;

public class CompCalculoInssFolhaPagamento {
    AuxBCInss auxBcIcms = new AuxBCInss();
    AuxCalcInssNormal auxIcmsNormal = new AuxCalcInssNormal();
    AuxCalcInssEscalonado auxIcmsEscalonado = new AuxCalcInssEscalonado();
    AuxCalcInssEmpresa auxIcmsEmpresa = new AuxCalcInssEmpresa();

    public void calcularInss(BaseCalcInssParams params) {
        BaseCalcInss valores = new BaseCalcInss();
        if (TMethods.isEquals((Object)params.getCodigoEsocIndInssMv(), (Object)"3")) {
            this.zerarValoresInss(valores);
            return;
        }
        this.auxBcIcms.calcularBcInss(valores, params);
        EnumConstTipoCalcTabelaInss tipoCalc = params.getCalcularVrInssEscalonado();
        switch (tipoCalc) {
            case CALCULO_NORMAL: {
                this.auxIcmsNormal.calcularInss(params, valores);
                break;
            }
            case CALCULO_ESCALONADO: {
                this.auxIcmsEscalonado.calcularInss(valores, params);
                break;
            }
            default: {
                throw new ExceptionErroProgramacao("tipo calculo inss nao definido: " + String.valueOf(tipoCalc));
            }
        }
        this.auxIcmsEmpresa.calcularInss(params, valores);
    }

    private void zerarValoresInss(BaseCalcInss movimento) {
        movimento.setBcInssSalario(0.0);
        movimento.setAliqInssSalario(0.0);
        movimento.setVrInssSalario(0.0);
        movimento.setBcInssFerias(0.0);
        movimento.setAliqInssFerias(0.0);
        movimento.setVrInssFerias(0.0);
    }
}

