/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorrules.nfe;

import com.touchcomp.basementor.constants.enums.configuracaocertificado.ConstAmbiente;
import com.touchcomp.basementor.constants.enums.nfce.EnumConstNFCeVersaoQRCode;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeVersao;
import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.hashmd5.ToolHashMD5;
import com.touchcomp.basementortools.tools.hexadecimal.ToolHexString;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;

public class CompNFe {
    public static Integer getCodNumericoAleatorio(EnumConstNFeVersao versao) {
        int MAX_NR_CASAS = 8;
        switch (versao) {
            case VERSAO_3_10: {
                break;
            }
        }
        return ToolNumber.getNrAleatorio((int)MAX_NR_CASAS);
    }

    public static int getCodigoVerificador(String chaveNfe) {
        return ToolNumber.getDigitoVerificadorMod11((String)chaveNfe);
    }

    public static String getSerie(EnumConstNFeVersao versao, String chaveNfe) {
        if (chaveNfe == null || chaveNfe.length() < 44) {
            return null;
        }
        return chaveNfe.substring(22, 25);
    }

    public static Long getNumeroDoc(EnumConstNFeVersao versao, String chaveNfe) {
        if (chaveNfe == null || chaveNfe.length() < 44) {
            return null;
        }
        return Long.valueOf(chaveNfe.substring(25, 34));
    }

    public static String getCodigoUf(EnumConstNFeVersao versao, String chaveNfe) {
        if (chaveNfe == null || chaveNfe.length() < 44) {
            return null;
        }
        return chaveNfe.substring(0, 2);
    }

    public static String getChaveNFe(String codUf, Date dataEmissao, String cnpjEmit, String codModelo, String serie, Long numero, String formaEmissaoNfe, String codNumerico) {
        StringBuilder sb = new StringBuilder();
        sb.append(ToolString.completaZeros((String)codUf, (int)2));
        sb.append(ToolDate.dateToStr((Date)dataEmissao, (String)"yyMM"));
        sb.append(ToolString.onlyNumbers((String)cnpjEmit));
        sb.append(ToolString.onlyNumbers((String)codModelo));
        sb.append(ToolString.completaZeros((String)serie, (int)3, (boolean)true));
        sb.append(ToolString.completaZeros((String)numero.toString(), (int)9, (boolean)true));
        sb.append(formaEmissaoNfe);
        sb.append(ToolString.completaZeros((String)ToolString.onlyNumbers((String)codNumerico), (int)8, (boolean)true));
        sb.append(ToolNumber.getDigitoVerificadorMod11((String)sb.toString()));
        return sb.toString();
    }

    public static String getURLQrCodeNFCe(String urlBaseSefaz, String chaveAcesso, EnumConstNFCeVersaoQRCode versaoQRCode, ConstAmbiente tipoAmbiente, String identificadorCSC, String codigoHash) {
        StringBuilder sb = new StringBuilder();
        sb.append(urlBaseSefaz);
        sb.append(chaveAcesso);
        sb.append("|");
        sb.append(versaoQRCode.getValue());
        sb.append("|");
        sb.append(tipoAmbiente.getCodigo());
        sb.append("|");
        sb.append(Long.valueOf(identificadorCSC));
        sb.append("|");
        sb.append(codigoHash);
        return sb.toString();
    }

    public static String getCodigoHashQrCodeNFCe(String chaveAcesso, EnumConstNFCeVersaoQRCode versaoQRCode, ConstAmbiente tipoAmbiente, String identificadorCSC, String csc) throws ExceptionJaxb {
        StringBuilder sb = new StringBuilder();
        sb.append(chaveAcesso);
        sb.append("|");
        sb.append(versaoQRCode.getValue());
        sb.append("|");
        sb.append(tipoAmbiente.getCodigo());
        sb.append("|");
        sb.append(Long.valueOf(identificadorCSC));
        sb.append(csc);
        return ToolHashMD5.gerarHashSHA1((String)sb.toString());
    }

    public static String getURLQrCodeNFCeOffLine(String urlBaseSefaz, String chaveAcesso, EnumConstNFCeVersaoQRCode versaoQRCode, ConstAmbiente tipoAmbiente, String identificadorCSC, String codigoHash, Date dataEmissao, Double valorTotal, String digestValue) {
        String pattern = "#0.00";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
        unusualSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(unusualSymbols);
        StringBuilder sb = new StringBuilder();
        sb.append(urlBaseSefaz);
        sb.append(chaveAcesso);
        sb.append("|");
        sb.append(versaoQRCode.getValue());
        sb.append("|");
        sb.append(tipoAmbiente.getCodigo());
        sb.append("|");
        sb.append(ToolDate.dateToStr((Date)dataEmissao, (String)"DD"));
        sb.append("|");
        sb.append(decimalFormat.format(valorTotal));
        sb.append("|");
        sb.append(ToolHexString.encodeToHex((String)digestValue));
        sb.append("|");
        sb.append(Long.valueOf(identificadorCSC));
        sb.append("|");
        sb.append(codigoHash);
        return sb.toString();
    }

    public static String getCodigoHashQrCodeNFCeOffLine(String chaveAcesso, EnumConstNFCeVersaoQRCode versaoQRCode, ConstAmbiente tipoAmbiente, String identificadorCSC, String csc, Date dataEmissao, Double valorTotal, String digestValue) throws ExceptionJaxb {
        String pattern = "#0.00";
        DecimalFormat decimalFormat = new DecimalFormat(pattern);
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
        unusualSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(unusualSymbols);
        StringBuilder sb = new StringBuilder();
        sb.append(chaveAcesso);
        sb.append("|");
        sb.append(versaoQRCode.getValue());
        sb.append("|");
        sb.append(tipoAmbiente.getCodigo());
        sb.append("|");
        sb.append(ToolDate.dateToStr((Date)dataEmissao, (String)"DD"));
        sb.append("|");
        sb.append(decimalFormat.format(valorTotal));
        sb.append("|");
        sb.append(ToolHexString.encodeToHex((String)digestValue));
        sb.append("|");
        sb.append(Long.valueOf(identificadorCSC));
        sb.append(csc);
        return ToolHashMD5.gerarHashSHA1((String)sb.toString());
    }
}

