/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.certificado;

import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorlogger.TLogger;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;

public class ToolCertificado {
    public static boolean isExpired(InputStream certificate, String senha) throws ExceptionCertificado {
        try {
            X509Certificate cert = ToolCertificado.getCertificate(certificate, senha);
            cert.checkValidity();
            return false;
        }
        catch (CertificateExpiredException ex) {
            TLogger.get(ToolCertificado.class).error((Throwable)ex);
            return true;
        }
        catch (CertificateNotYetValidException ex) {
            TLogger.get(ToolCertificado.class).error((Throwable)ex);
            return true;
        }
    }

    public static Date getDataExpiracao(InputStream certificate, String senha) throws ExceptionCertificado {
        X509Certificate cert = ToolCertificado.getCertificate(certificate, senha);
        return cert.getNotAfter();
    }

    public static X509Certificate getCertificate(InputStream certificate, String senha) throws ExceptionCertificado {
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(certificate, senha.toCharArray());
            KeyStore.PrivateKeyEntry pkEntry = null;
            Enumeration<String> aliasesEnum = ks.aliases();
            while (aliasesEnum.hasMoreElements()) {
                String alias = aliasesEnum.nextElement();
                System.out.println(alias);
                if (!ks.isKeyEntry(alias)) continue;
                pkEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(senha.toCharArray()));
                break;
            }
            X509Certificate cert = (X509Certificate)pkEntry.getCertificate();
            return cert;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (CertificateException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (KeyStoreException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (UnrecoverableEntryException ex) {
            throw new ExceptionCertificado(ex);
        }
        catch (IOException ex) {
            throw new ExceptionCertificado(ex);
        }
    }

    public static enum EnumTipoCertificado {
        CERTIFICADO_A1(0),
        CERTIFICADO_A3(1),
        CERTIFICADO_WINDOWS(2);

        int value;

        private EnumTipoCertificado(int value) {
            this.value = value;
        }

        public static EnumTipoCertificado toEnum(int code) {
            if (code == 0) {
                return CERTIFICADO_A1;
            }
            return CERTIFICADO_A3;
        }
    }
}

