/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.certificado;

import com.touchcomp.basementorexceptions.exceptions.impl.certificado.ExceptionCertificado;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.certificado.ToolCertificadoSocketUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class ToolCertificadoSocketFactTrustAll
implements ProtocolSocketFactory {
    private SSLContext ssl = null;
    private final X509Certificate certificate;
    private final PrivateKey privateKey;

    public ToolCertificadoSocketFactTrustAll(X509Certificate certificate, PrivateKey privateKey) {
        this.certificate = certificate;
        this.privateKey = privateKey;
        System.setProperty("https.protocols", "SSLv3,TLSv1.2");
        System.setProperty("jdk.tls.client.protocols", "TLSv1.2");
        System.out.println("\n\n\nConfigurando propriedades para envio\n\n\n");
    }

    private SSLContext getSSLContext() throws ExceptionCertificado {
        if (this.ssl == null) {
            this.ssl = new ToolCertificadoSocketUtil().createSSLContext(this.certificate, this.privateKey);
        }
        return this.ssl;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        try {
            if (params == null) {
                throw new IllegalArgumentException("Parameters may not be null");
            }
            int timeout = params.getConnectionTimeout();
            SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
            if (timeout == 0) {
                return socketfactory.createSocket(host, port, localAddress, localPort);
            }
            Socket socket = socketfactory.createSocket();
            InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
            InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
            socket.bind(localaddr);
            socket.connect(remoteaddr, timeout);
            return socket;
        }
        catch (ExceptionCertificado ex) {
            throw new IOException(ex);
        }
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        try {
            return this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        }
        catch (ExceptionCertificado ex) {
            throw new IOException(ex);
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        try {
            return this.getSSLContext().getSocketFactory().createSocket(host, port);
        }
        catch (ExceptionCertificado ex) {
            throw new IOException(ex);
        }
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        try {
            return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        }
        catch (ExceptionCertificado ex) {
            throw new IOException(ex);
        }
    }

    private static void error(Exception log) {
        TLogger.get(ToolCertificadoSocketFactTrustAll.class).error((Throwable)log);
        System.out.println("ERROR: " + String.valueOf(log));
    }
}

