/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.certificado;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ToolKeystore {
    private static final int DEFAULT_SSL_PORT = 443;
    private static final String PROTOCOL = "TLSv1.3";

    public static File geraCadeiaCertificadosFile(File keystoreFile, String senha, String url) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(new FileInputStream(keystoreFile), senha.toCharArray());
        String host = new URI(url).getHost();
        ToolKeystore.get(keyStore, host);
        File tempFile = File.createTempFile("keystore", ".jks");
        keyStore.store(new FileOutputStream(tempFile), senha.toCharArray());
        return tempFile;
    }

    public static File geraCadeiaCertificadosFile(String url, String senha) throws Exception {
        File tempFile = File.createTempFile("keystore", ".jks");
        try (FileOutputStream fout = new FileOutputStream(tempFile);){
            fout.write(ToolKeystore.geraCadeiaCertificados(url, senha));
            fout.flush();
        }
        return tempFile;
    }

    public static byte[] geraCadeiaCertificados(String bankUrl, String senha) throws Exception {
        String host = new URI(bankUrl).getHost();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, senha.toCharArray());
        ToolKeystore.get(keyStore, host);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            keyStore.store(out, senha.toCharArray());
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private static void get(KeyStore keyStore, String host) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, CertificateEncodingException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        X509TrustManager defaultTrustManager = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
        SavingTrustManager savingTrustManager = new SavingTrustManager(defaultTrustManager);
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(null, new TrustManager[]{savingTrustManager}, null);
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        try (SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(host, 443);){
            sslSocket.setSoTimeout(10000);
            sslSocket.startHandshake();
        }
        if (savingTrustManager.chain != null) {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (int i = 0; i < savingTrustManager.chain.length; ++i) {
                X509Certificate certificate = savingTrustManager.chain[i];
                sha1.update(certificate.getEncoded());
                md5.update(certificate.getEncoded());
                String alias = String.format("%s.%s", host, i + 1);
                keyStore.setCertificateEntry(alias, certificate);
            }
        }
    }

    private static class SavingTrustManager
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private X509Certificate[] chain;

        SavingTrustManager(X509TrustManager trustManager) {
            this.trustManager = trustManager;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.chain = chain;
        }
    }
}

