/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.clone;

import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentSet;
import org.hibernate.proxy.HibernateProxy;

class AuxCloneEntity {
    AuxCloneEntity() {
    }

    private Object nullIdsBean(boolean cloneIt, Collection<? extends Object> dataList, List<String> rest) throws ExceptionReflection {
        Collection ret;
        if (dataList == null) {
            return null;
        }
        if (cloneIt) {
            ret = this.cloneCollection(dataList);
            for (Object object : dataList) {
                ret.add(this.nullIdsBean(cloneIt, object, rest));
            }
        } else {
            ret = dataList;
            for (Object object : dataList) {
                this.nullIdsBean(cloneIt, object, rest);
            }
        }
        return ret;
    }

    public Object nullIdsBean(boolean cloneIt, Object old, List<String> rest) throws ExceptionReflection {
        if (old == null) {
            return null;
        }
        if (rest == null) {
            rest = new LinkedList<String>();
        }
        try {
            PropertyDescriptor[] props;
            Object neww = old;
            Class clazz = neww.getClass();
            if (old instanceof HibernateProxy) {
                clazz = ((HibernateProxy)old).getHibernateLazyInitializer().getPersistentClass();
            }
            if (cloneIt) {
                neww = clazz.newInstance();
                BeanUtils.copyProperties((Object)neww, (Object)old);
            }
            BeanInfo bInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor p : props = bInfo.getPropertyDescriptors()) {
                this.checkProperty(cloneIt, clazz, p, neww, rest);
            }
            return neww;
        }
        catch (IntrospectionException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (IllegalAccessException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
        catch (InstantiationException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionReflection(ex);
        }
    }

    private void checkProperty(boolean cloneIt, Class baseClass, PropertyDescriptor p, Object obj, List<String> rest) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ExceptionReflection {
        Field field;
        if (p.getReadMethod() == null || p.getWriteMethod() == null) {
            return;
        }
        System.out.println(p.getReadMethod().getName());
        List restFound = this.filterRestrictions(rest, p);
        Method read = p.getReadMethod();
        Method write = p.getWriteMethod();
        if (read != null) {
            OneToMany oneToMany = read.getAnnotation(OneToMany.class);
            ManyToOne manyToOne = read.getAnnotation(ManyToOne.class);
            OneToOne oneToOne = read.getAnnotation(OneToOne.class);
            ManyToMany manyToMany = read.getAnnotation(ManyToMany.class);
            Cascade cascadeHibernate = read.getAnnotation(Cascade.class);
            if (oneToMany != null && this.checkIt(cloneIt, oneToMany.cascade(), cascadeHibernate, obj, read, write, restFound)) {
                return;
            }
            if (manyToOne != null && this.checkIt(cloneIt, manyToOne.cascade(), cascadeHibernate, obj, read, write, restFound)) {
                return;
            }
            if (oneToOne != null && this.checkIt(cloneIt, oneToOne.cascade(), cascadeHibernate, obj, read, write, restFound)) {
                return;
            }
            if (manyToMany != null && this.checkIt(cloneIt, manyToMany.cascade(), cascadeHibernate, obj, read, write, restFound)) {
                return;
            }
            Id id = p.getReadMethod().getAnnotation(Id.class);
            Version version = p.getReadMethod().getAnnotation(Version.class);
            if (id != null) {
                write.invoke(obj, new Object[]{null});
                return;
            }
            if (version != null) {
                write.invoke(obj, new Object[]{null});
                return;
            }
        }
        if ((field = ToolReflections.getField(baseClass, p.getName())) != null) {
            OneToMany oneToMany = field.getAnnotation(OneToMany.class);
            ManyToOne manyToOne = field.getAnnotation(ManyToOne.class);
            OneToOne oneToOne = field.getAnnotation(OneToOne.class);
            ManyToMany manyToMany = field.getAnnotation(ManyToMany.class);
            Cascade cascadeHibernate = field.getAnnotation(Cascade.class);
            if (oneToMany != null && this.checkIt(cloneIt, oneToMany.cascade(), cascadeHibernate, obj, read, write, restFound)) {
                return;
            }
            if (manyToOne != null && this.checkIt(cloneIt, manyToOne.cascade(), cascadeHibernate, obj, read, write, restFound)) {
                return;
            }
            if (oneToOne != null && this.checkIt(cloneIt, oneToOne.cascade(), cascadeHibernate, obj, read, write, restFound)) {
                return;
            }
            if (manyToMany != null && this.checkIt(cloneIt, manyToMany.cascade(), cascadeHibernate, obj, read, write, restFound)) {
                return;
            }
            Id id = field.getAnnotation(Id.class);
            Version version = field.getAnnotation(Version.class);
            if (id != null) {
                write.invoke(obj, new Object[]{null});
                return;
            }
            if (version != null) {
                write.invoke(obj, new Object[]{null});
                return;
            }
        }
    }

    private List filterRestrictions(List<String> rest, PropertyDescriptor p) {
        LinkedList<String> aux = new LinkedList<String>();
        if (rest != null) {
            for (String st : rest) {
                String sufix;
                String prefix = "";
                if (st.indexOf(".") >= 0) {
                    prefix = st.substring(0, st.indexOf("."));
                    sufix = st.substring(st.indexOf(".") + 1);
                } else {
                    prefix = sufix = st;
                }
                if (!prefix.equalsIgnoreCase(p.getName())) continue;
                aux.add(sufix);
            }
        }
        return aux;
    }

    private boolean liberadoClone(List<String> restFound, PropertyDescriptor p) {
        for (String str : restFound) {
            if (str.indexOf(".") >= 0 || !str.equalsIgnoreCase(p.getName())) continue;
            return false;
        }
        return true;
    }

    private boolean checkIt(boolean cloneIt, CascadeType[] cascade, Cascade cascadeHibernate, Object obj, Method read, Method write, List restFound) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ExceptionReflection {
        Boolean rest = Arrays.stream(cascade).filter(c -> c.equals((Object)CascadeType.ALL) || c.equals((Object)CascadeType.MERGE) || c.equals((Object)CascadeType.PERSIST)).findFirst().isPresent();
        if (rest.booleanValue()) {
            this.checkIt(cloneIt, obj, read, write, restFound);
            return rest;
        }
        if (cascadeHibernate == null || cascadeHibernate.value() == null) {
            return false;
        }
        rest = Arrays.stream(cascadeHibernate.value()).filter(c -> c.equals((Object)org.hibernate.annotations.CascadeType.ALL) || c.equals((Object)org.hibernate.annotations.CascadeType.MERGE) || c.equals((Object)org.hibernate.annotations.CascadeType.PERSIST)).findFirst().isPresent();
        if (rest.booleanValue()) {
            this.checkIt(cloneIt, obj, read, write, restFound);
            return rest;
        }
        return rest;
    }

    private void checkIt(boolean cloneIt, Object obj, Method read, Method write, List restFound) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ExceptionReflection {
        System.out.println("entity/list/data: " + read.getName());
        Object toClone = read.invoke(obj, new Object[0]);
        Object cloned = null;
        cloned = toClone != null && Collection.class.isAssignableFrom(toClone.getClass()) ? this.nullIdsBean(cloneIt, (Collection)toClone, (List<String>)restFound) : this.nullIdsBean(cloneIt, toClone, (List<String>)restFound);
        write.invoke(obj, cloned);
    }

    private Collection cloneCollection(Collection<? extends Object> dataList) throws ExceptionReflection {
        if (PersistentBag.class.isAssignableFrom(dataList.getClass())) {
            return new LinkedList();
        }
        if (PersistentSet.class.isAssignableFrom(dataList.getClass())) {
            return new LinkedHashSet();
        }
        return ToolClone.clone(dataList);
    }
}

