/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.converter.impl;

import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.converter.impl.RestrictionOption;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;

public class ObjectOpFinder
implements OpFinder<Object> {
    private Format format;

    public ObjectOpFinder() {
    }

    public ObjectOpFinder(Format format) {
        this.format = format;
    }

    @Override
    public List<RestrictionOption> getRestrictions() {
        ArrayList<RestrictionOption> aux = new ArrayList<RestrictionOption>();
        RestrictionOption opt = null;
        opt = new RestrictionOption();
        opt.setDescription("Contendo");
        opt.setRestriction(EnumConstantsCriteria.ILIKE);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Diferente de");
        opt.setRestriction(EnumConstantsCriteria.NOT_EQUAL);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Igual a");
        opt.setRestriction(EnumConstantsCriteria.EQUAL);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Nulo");
        opt.setRestriction(EnumConstantsCriteria.IS_NULL);
        aux.add(opt);
        opt = new RestrictionOption();
        opt.setDescription("Nao Nulo");
        opt.setRestriction(EnumConstantsCriteria.IS_NOT_NULL);
        aux.add(opt);
        return aux;
    }

    @Override
    public Format getFormatter() {
        return this.format;
    }

    @Override
    public void setFormatter(Format format) {
        this.format = format;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    public String convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (this.format == null) {
            return String.valueOf(value);
        }
        return this.format.format(value);
    }

    @Override
    public Object convertStrNativeValue(String value) {
        return value;
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (this.getFormatter() == null) {
            return String.valueOf(value);
        }
        return this.getFormatter().format(value);
    }

    @Override
    public String convertValueToStringNative(Object value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Class getConverterClass() {
        return Object.class;
    }

    @Override
    public String getDefaultValueStr() {
        return this.convertValueToStringNative(this.getDefaultValue());
    }

    @Override
    public String getDefaultValueStrNative() {
        return this.convertValueToString(this.getDefaultValue());
    }

    @Override
    public Object convertValue(String value) {
        return value;
    }

    @Override
    public boolean isValid(Object value) {
        return true;
    }
}

