/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.csv;

import com.csvreader.CsvWriter;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.file.ToolFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ToolCSV {
    public static File toCSV(List<Map> data) throws ExceptionIO {
        try {
            File f = ToolFile.createTempFile("data_file", ".csv");
            CsvWriter writer = new CsvWriter((OutputStream)new FileOutputStream(f), ';', Charset.defaultCharset());
            ToolCSV.writeData(data, writer);
            return f;
        }
        catch (IOException ex) {
            TLogger.get(ToolCSV.class).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    public static String toCSVStr(List<Map> data) throws ExceptionIO {
        try {
            StringWriter sw = new StringWriter();
            CsvWriter writer = new CsvWriter((Writer)sw, ';');
            ToolCSV.writeData(data, writer);
            return sw.toString();
        }
        catch (IOException ex) {
            TLogger.get(ToolCSV.class).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    private static void writeData(List<Map> data, CsvWriter writer) throws IOException {
        String[] header = null;
        for (Map map : data) {
            if (header == null) {
                header = new String[map.keySet().size()];
                int i = 0;
                for (Object obj : map.keySet()) {
                    header[i] = obj == null ? "" : String.valueOf(obj);
                    ++i;
                }
                writer.writeRecord(header);
            }
            Collection values = map.values();
            int i = 0;
            String[] record = new String[values.size()];
            for (Object obj : values) {
                record[i] = obj == null ? "" : String.valueOf(obj);
                ++i;
            }
            writer.writeRecord(record);
        }
        writer.flush();
        writer.close();
    }
}

