/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.downloadweb;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.file.ToolFile;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ToolDownloadWeb {
    private static DownloadPack downloadFileToServerInternalHTTPS(String path, final InternalProxy pr, HashMap<String, String> params) throws MalformedURLException, IOException {
        if (pr != null && pr.authenticate) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(pr.usuario, pr.senha.toCharArray());
                }
            });
        }
        URL u = new URL(path);
        HttpsURLConnection con = null;
        if (pr != null) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(pr.host, pr.porta));
            con = (HttpsURLConnection)u.openConnection(proxy);
        } else {
            con = (HttpsURLConnection)u.openConnection();
        }
        con.setRequestMethod("GET");
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
        if (params != null) {
            for (Map.Entry entry : params.entrySet()) {
                con.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        con.connect();
        try {
            return new DownloadPack(con.getInputStream(), con.getContentLength());
        }
        catch (FileNotFoundException ex) {
            return new DownloadPack(con.getErrorStream(), con.getContentLength());
        }
    }

    protected static DownloadPack downloadFileToServerInternal(String path, final InternalProxy pr) throws MalformedURLException, IOException {
        try {
            ToolDownloadWeb.setAcceptAllProviders();
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.getLogger(ToolDownloadWeb.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (KeyManagementException ex) {
            Logger.getLogger(ToolDownloadWeb.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (pr != null && pr.authenticate) {
            System.out.println("setando autenticacao proxy...");
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(pr.usuario, pr.senha.toCharArray());
                }
            });
        }
        URL u = new URL(path);
        HttpURLConnection con = null;
        if (pr != null) {
            System.out.println("download usando proxy...");
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(pr.host, pr.porta));
            con = (HttpURLConnection)u.openConnection(proxy);
        } else {
            con = (HttpURLConnection)u.openConnection();
        }
        con.setRequestMethod("GET");
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.2.3) Gecko/20100401");
        con.connect();
        return new DownloadPack(con.getInputStream(), con.getContentLength());
    }

    private static void setAcceptAllProviders() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        System.out.println("Setando para aceitar todos os certificados....");
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public static void downloadFileToServer(File fileTo, String path) throws MalformedURLException, IOException {
        ToolDownloadWeb.downloadFileToServer(fileTo, path, (DownloadProgress)null);
    }

    public static void downloadFileToServer(File fileTo, String path, DownloadProgress downloadProgress) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternal(path, null);
        ToolDownloadWeb.writeToFile(in, fileTo, downloadProgress);
    }

    public static void downloadFileToServerHttps(File fileTo, String path, HashMap<String, String> params) throws MalformedURLException, IOException {
        ToolDownloadWeb.downloadFileToServerHttps(fileTo, path, params, null);
    }

    public static void downloadFileToServerHttps(File fileTo, String path, HashMap<String, String> params, DownloadProgress downloadProgress) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternalHTTPS(path, null, params);
        ToolDownloadWeb.writeToFile(in, fileTo, downloadProgress);
    }

    public static void downloadFileToServer(File fileTo, String path, InternalProxy p) throws MalformedURLException, IOException {
        ToolDownloadWeb.downloadFileToServer(fileTo, path, p, null);
    }

    public static void downloadFileToServer(File fileTo, String path, InternalProxy p, DownloadProgress downloadProgress) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternal(path, p);
        ToolDownloadWeb.writeToFile(in, fileTo, downloadProgress);
    }

    public static void downloadFileToServerHttps(File fileTo, String path, InternalProxy p) throws MalformedURLException, IOException {
        ToolDownloadWeb.downloadFileToServerHttps(fileTo, path, p, null);
    }

    public static void downloadFileToServerHttps(File fileTo, String path, InternalProxy p, DownloadProgress downloadProgress) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternalHTTPS(path, p, null);
        ToolDownloadWeb.writeToFile(in, fileTo, downloadProgress);
    }

    public static byte[] downloadFileToServerByteArray(String path) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternal(path, null);
        return ToolDownloadWeb.writeByteArray(in);
    }

    public static byte[] downloadFileToServerByteArray(String path, InternalProxy p) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternal(path, p);
        return ToolDownloadWeb.writeByteArray(in);
    }

    public static byte[] downloadFileToServerByteArrayHttps(String path) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternalHTTPS(path, null, null);
        return ToolDownloadWeb.writeByteArray(in);
    }

    public static byte[] downloadFileToServerByteArrayHttps(String path, InternalProxy p) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternalHTTPS(path, null, null);
        return ToolDownloadWeb.writeByteArray(in);
    }

    public static byte[] downloadFileToServerByteArray(File fileTo, String path, InternalProxy p) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternal(path, p);
        return ToolDownloadWeb.writeByteArray(in);
    }

    public static byte[] downloadFileToServerByteArrayHttps(File fileTo, String path, InternalProxy p) throws MalformedURLException, IOException {
        DownloadPack in = ToolDownloadWeb.downloadFileToServerInternalHTTPS(path, p, null);
        return ToolDownloadWeb.writeByteArray(in);
    }

    public static byte[] writeByteArray(DownloadPack in) throws MalformedURLException, IOException {
        int n;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((n = in.input.read(buf)) >= 0) {
            baos.write(buf, 0, n);
        }
        byte[] data = baos.toByteArray();
        return data;
    }

    private static void writeToFile(DownloadPack in, File fileTo, DownloadProgress downloadProgress) throws MalformedURLException, IOException {
        try {
            ToolFile.copyFile(in.input, new FileOutputStream(fileTo), in.contentLength, downloadProgress);
        }
        catch (FileNotFoundException ex) {
            throw new IOException(ex);
        }
        catch (ExceptionIO ex) {
            throw new IOException(ex);
        }
    }

    public static boolean webServerIsOn(String address) {
        try {
            URL siteURL = new URL(address);
            HttpURLConnection connection = (HttpURLConnection)siteURL.openConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            int responseCode = connection.getResponseCode();
            connection.disconnect();
            return responseCode >= 200 && responseCode < 300;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static class InternalProxy {
        private String host;
        private int porta;
        private String usuario;
        private String senha;
        private boolean authenticate = false;

        public InternalProxy(String host, int porta) {
            this.host = host;
            this.porta = porta;
        }

        public InternalProxy(String host, int porta, String usuario, String senha) {
            this.host = host;
            this.porta = porta;
            this.usuario = usuario;
            this.senha = senha;
            this.authenticate = true;
        }

        public String getHost() {
            return this.host;
        }

        public int getPorta() {
            return this.porta;
        }

        public String getUsuario() {
            return this.usuario;
        }

        public String getSenha() {
            return this.senha;
        }

        public boolean isAuthenticate() {
            return this.authenticate;
        }
    }

    public static class DownloadPack {
        InputStream input;
        int contentLength;

        public DownloadPack(InputStream input, int contentLength) {
            this.input = input;
            this.contentLength = contentLength;
        }
    }

    public static interface DownloadProgress
    extends ToolFile.CopyProgress {
    }
}

