/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.dtotransfer;

import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.dtotransfer.BuilderDTO;
import com.touchcomp.basementortools.tools.dtotransfer.FieldPair;
import com.touchcomp.basementortools.tools.dtotransfer.ToolDTOBuilder;
import com.touchcomp.basementortools.tools.dtotransfer.conversor.DTODefaultEntityConversor;
import com.touchcomp.basementortools.tools.dtotransfer.conversor.DTOEntityConversor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class BuilderEntity<T, S> {
    private final ToolDTOBuilder<T, S> builder;
    private boolean convertFindEntities = true;

    public BuilderEntity(ToolDTOBuilder<T, S> builder) {
        this.builder = builder;
    }

    public BuilderEntity(ToolDTOBuilder<T, S> builder, boolean convertFindEntities) {
        this.builder = builder;
        this.convertFindEntities = convertFindEntities;
    }

    public T toEntity(S data) throws ExceptionReflection {
        try {
            Object ret = this.builder.entityClass.newInstance();
            this.toEntityInternal(ret, data, this.builder.fieldsPair);
            return ret;
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BuilderEntity.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BuilderEntity.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
    }

    public T toEntity(T base, S data) throws ExceptionReflection {
        T ret = base;
        if (ret == null) {
            try {
                ret = this.builder.entityClass.newInstance();
            }
            catch (InstantiationException ex) {
                Logger.getLogger(BuilderEntity.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionReflection(ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(BuilderEntity.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionReflection(ex);
            }
        }
        this.toEntityInternal(ret, data, this.builder.fieldsPair);
        return ret;
    }

    private Object toEntityInternal(Class type, Object data, Object base, List<FieldPair> pairs) throws ExceptionReflection {
        Object ret = base;
        if (ret == null) {
            try {
                ret = type.newInstance();
            }
            catch (InstantiationException ex) {
                Logger.getLogger(BuilderEntity.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionReflection(ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(BuilderEntity.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionReflection(ex);
            }
        }
        this.toEntityInternal(ret, data, pairs);
        return ret;
    }

    private Object toEntityInternal(Object entity, Object dto, List<FieldPair> pairs) throws ExceptionReflection {
        if (dto == null) {
            return null;
        }
        for (FieldPair f : pairs) {
            Object set = this.invockeGetMethod(f.getFieldDTO(), dto);
            switch (f.getFieldType()) {
                case PRIMITIVE: {
                    this.invockeSetMethod(f.getFieldEntity(), entity, set);
                    break;
                }
                case METHOD_OBJ_PATH: {
                    break;
                }
                case OBJECT_FIELD: {
                    if (f.getOnlyView().booleanValue() || !this.isConvertFindEntities()) break;
                    DTOEntityConversor conversor = this.getConversor(f.getFieldEntityType(), f.getFieldParentEntity().getPropertyType());
                    if (conversor != null) {
                        try {
                            String fieldName = f.getFieldEntity().getName();
                            Class type = f.getFieldEntityType();
                            set = conversor.convertToEntity(type, fieldName, set);
                            this.invockeSetMethod(f.getFieldEntity(), entity, set);
                            break;
                        }
                        catch (ExceptionObjNotFound ex) {
                            Logger.getLogger(BuilderEntity.class.getName()).log(Level.SEVERE, null, ex);
                            throw new ExceptionReflection(ex.getFormattedMessage(), new Object[0]);
                        }
                    }
                    throw new ExceptionErroProgramacao("Nao foi definido um conversor de entidades.");
                }
                case OBJECT: {
                    if (set == null) break;
                    Object base = this.invockeGetMethod(f.getFieldEntity(), entity);
                    set = this.toEntityInternal(f.getFieldEntity().getPropertyType(), set, base, f.getChildren());
                    this.invockeSetMethod(f.getFieldEntity(), entity, set);
                    break;
                }
                case OBJECT_COLLECTION: {
                    Object base;
                    try {
                        if (set != null) {
                            Collection collections = (Collection)set;
                            Collection nova = (Collection)this.invockeGetMethod(f.getFieldEntity(), entity);
                            if (nova == null) {
                                nova = (Collection)collections.getClass().newInstance();
                            } else {
                                nova.clear();
                            }
                            for (Object child : collections) {
                                base = null;
                                set = this.toEntityInternal(f.getFieldEntityType(), child, base, f.getChildren());
                                nova.add(set);
                            }
                            this.invockeSetMethod(f.getFieldEntity(), entity, nova);
                            break;
                        }
                        this.invockeSetMethod(f.getFieldEntity(), entity, null);
                        break;
                    }
                    catch (InstantiationException ex) {
                        Logger.getLogger(BuilderEntity.class.getName()).log(Level.SEVERE, null, ex);
                        throw new ExceptionReflection(ex);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(BuilderEntity.class.getName()).log(Level.SEVERE, null, ex);
                        throw new ExceptionReflection(ex);
                    }
                }
            }
        }
        return entity;
    }

    private DTOEntityConversor getConversor(Class fieldEntityType, Class<?> fieldType) {
        DTODefaultEntityConversor def = null;
        for (DTOEntityConversor conversor : this.builder.conversors) {
            if (!fieldEntityType.equals(conversor.getEntity()) || !fieldType.equals(conversor.getFieldType())) continue;
            return conversor;
        }
        for (DTOEntityConversor conversor : this.builder.conversors) {
            if (conversor.getEntity() == null || !conversor.getEntity().isAssignableFrom(fieldEntityType) || !conversor.getFieldType().isAssignableFrom(fieldType)) continue;
            return conversor;
        }
        if (def == null) {
            def = new DTODefaultEntityConversor();
        }
        return def;
    }

    private Object invockeGetMethod(PropertyDescriptor fieldEntity, Object entity) throws ExceptionReflection {
        try {
            return fieldEntity.getReadMethod().invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BuilderDTO.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(BuilderDTO.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(BuilderDTO.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
    }

    private void invockeSetMethod(PropertyDescriptor field, Object invocke, Object set) throws ExceptionReflection {
        try {
            if (field.getPropertyType().equals(Date.class) && set != null && set.getClass().equals(Long.class)) {
                set = new Date((Long)set);
            } else if (field.getPropertyType().equals(byte[].class) && set != null && set.getClass().equals(String.class)) {
                set = set.toString().getBytes();
            }
            field.getWriteMethod().invoke(invocke, set);
        }
        catch (IllegalAccessException ex) {
            System.out.println("Erro ao chamar o metodo " + field.getWriteMethod().getName() + " valor " + String.valueOf(set) + " tipo: " + String.valueOf(set != null ? set.getClass() : ""));
            Logger.getLogger(BuilderDTO.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
        catch (IllegalArgumentException ex) {
            System.out.println("Erro ao chamar o metodo " + field.getWriteMethod().getName() + " valor " + String.valueOf(set) + " tipo: " + String.valueOf(set != null ? set.getClass() : ""));
            Logger.getLogger(BuilderDTO.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
        catch (InvocationTargetException ex) {
            System.out.println("Erro ao chamar o metodo " + field.getWriteMethod().getName() + " valor " + String.valueOf(set) + " tipo: " + String.valueOf(set != null ? set.getClass() : ""));
            Logger.getLogger(BuilderDTO.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionReflection(ex);
        }
    }

    public boolean isConvertFindEntities() {
        return this.convertFindEntities;
    }

    public void setConvertFindEntities(boolean convertFindEntities) {
        this.convertFindEntities = convertFindEntities;
    }
}

