/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.excel;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.json.ExceptionJson;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementortools.tools.excel.impl.converter.ExcelJsonConverter;
import com.touchcomp.basementortools.tools.excel.impl.read.ExcelCSVRead;
import com.touchcomp.basementortools.tools.excel.impl.read.ExcelMapRead;
import com.touchcomp.basementortools.tools.excel.impl.read.ExcelTextRead;
import com.touchcomp.basementortools.tools.excel.impl.read.ExcelXLSXRead;
import com.touchcomp.basementortools.tools.excel.impl.write.ExcelXLSXWrite;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import com.touchcomp.basementortools.tools.excel.model.ExcelType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ToolExcel {
    public static ExcelSheet read(String data) throws ExceptionIO {
        return ToolExcel.read(data, ';', 0);
    }

    public static ExcelSheet read(String data, char delimiter) throws ExceptionIO {
        return ToolExcel.read(data, delimiter, 0);
    }

    public static ExcelSheet read(String data, char delimiter, int startLine) throws ExceptionIO {
        try {
            return new ExcelTextRead(data).setDelimiter(delimiter).setStartLine(startLine).read();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO((IOException)ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex);
        }
    }

    public static ExcelSheet readCsv(File data) throws ExceptionIO {
        return ToolExcel.readCsv(data, ';', 0);
    }

    public static ExcelSheet readCsv(File data, char delimiter) throws ExceptionIO {
        return ToolExcel.readCsv(data, delimiter, 0);
    }

    public static ExcelSheet readCsv(File data, char delimiter, int startLine) throws ExceptionIO {
        try {
            return new ExcelCSVRead(data).setDelimiter(delimiter).setStartLine(startLine).read();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO((IOException)ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex);
        }
    }

    public static ExcelSheet readCsv(InputStream data, char delimiter, int startLine) throws ExceptionIO {
        try {
            return new ExcelCSVRead(data).setDelimiter(delimiter).setStartLine(startLine).read();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO((IOException)ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex);
        }
    }

    public static ExcelSheet read(File file) throws ExceptionIO {
        int lastIndexOf = file.getName().lastIndexOf(".");
        String extension = file.getName();
        if (lastIndexOf >= 0) {
            extension = file.getName().substring(lastIndexOf);
        }
        if (extension.contains(ExcelType.CSV.getFileExt())) {
            return ToolExcel.read(file, ExcelType.CSV);
        }
        if (extension.contains(ExcelType.XLSX.getFileExt())) {
            return ToolExcel.read(file, ExcelType.XLSX);
        }
        return ToolExcel.read(file, ExcelType.XLS);
    }

    public static ExcelSheet read(File file, int startLine, int endLine) throws ExceptionIO {
        if (file.getName().toLowerCase().endsWith(ExcelType.CSV.getFileExt())) {
            return ToolExcel.read(file, ExcelType.CSV, startLine, endLine);
        }
        if (file.getName().toLowerCase().endsWith(ExcelType.XLSX.getFileExt())) {
            return ToolExcel.read(file, ExcelType.XLSX, startLine, endLine);
        }
        return ToolExcel.read(file, ExcelType.XLS, startLine, endLine);
    }

    public static ExcelSheet read(File file, ExcelType type) throws ExceptionIO {
        try {
            switch (type) {
                case CSV: {
                    return ToolExcel.read(new FileInputStream(file), ExcelType.CSV);
                }
                case XLS: {
                    return ToolExcel.read(new FileInputStream(file), ExcelType.XLS);
                }
                case XLSX: {
                    return ToolExcel.read(new FileInputStream(file), ExcelType.XLSX);
                }
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex);
        }
    }

    public static ExcelSheet read(File file, ExcelType type, int startLine, int endLine) throws ExceptionIO {
        try {
            switch (type) {
                case CSV: {
                    return ToolExcel.read(new FileInputStream(file), ExcelType.CSV, startLine, endLine);
                }
                case XLS: {
                    return ToolExcel.read(new FileInputStream(file), ExcelType.XLS, startLine, endLine);
                }
                case XLSX: {
                    return ToolExcel.read(new FileInputStream(file), ExcelType.XLSX, startLine, endLine);
                }
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex);
        }
    }

    public static ExcelSheet read(InputStream file, ExcelType type) throws ExceptionIO {
        try {
            switch (type) {
                case CSV: {
                    return new ExcelCSVRead(file).read();
                }
                case XLS: {
                    return new ExcelXLSXRead(file, type).read();
                }
                case XLSX: {
                    return new ExcelXLSXRead(file, type).read();
                }
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex);
        }
    }

    public static ExcelSheet read(InputStream file, ExcelType type, int startLine, int endLine) throws ExceptionIO {
        try {
            switch (type) {
                case CSV: {
                    return new ExcelCSVRead(file, startLine, endLine).read();
                }
                case XLS: {
                    return new ExcelXLSXRead(file, type, startLine, endLine).read();
                }
                case XLSX: {
                    return new ExcelXLSXRead(file, type, startLine, endLine).read();
                }
            }
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex);
        }
    }

    public static void write(File file, ExcelType type, ExcelSheet sheet) throws ExceptionIO, ExceptionParseObject {
        try {
            switch (type) {
                case CSV: 
                case XLS: {
                    FileOutputStream fout = new FileOutputStream(file);
                    new ExcelXLSXWrite(fout, type).write(sheet);
                    fout.close();
                    fout.flush();
                }
                case XLSX: {
                    FileOutputStream fout = new FileOutputStream(file);
                    new ExcelXLSXWrite(new FileOutputStream(file), type).write(sheet);
                    fout.close();
                    fout.flush();
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ToolExcel.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionIO(ex);
        }
    }

    public static String convertToJson(ExcelSheet dados) throws ExceptionJson, ExceptionParseObject, ExceptionIO {
        return new ExcelJsonConverter().convertToJson(dados);
    }

    public static String convertToJson(ExcelSheet.Row header, ExcelSheet.Row row) throws ExceptionJson, ExceptionParseObject, ExceptionIO {
        return new ExcelJsonConverter().convertToJson(header, row);
    }

    public static ExcelSheet convertToExcel(String json) throws ExceptionIO {
        return new ExcelJsonConverter().convertToExcel(json);
    }

    public static ExcelType getExcelType(File f) throws ExceptionInvalidData {
        String extension = f.getName().substring(f.getName().lastIndexOf("."));
        extension = extension.replaceAll("\\.", "");
        for (ExcelType value : ExcelType.values()) {
            if (!value.getFileExt().equalsIgnoreCase(extension)) continue;
            return value;
        }
        throw new ExceptionInvalidData("E.GEN.000043", new Object[]{f.getName()});
    }

    public static ExcelSheet read(List<Map> dados) {
        ExcelMapRead reader = new ExcelMapRead(dados);
        return reader.read();
    }
}

