/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.excel.impl.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.gson.internal.LinkedTreeMap;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.json.ExceptionJson;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.excel.model.ExcelCellType;
import com.touchcomp.basementortools.tools.excel.model.ExcelSheet;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.json.ToolJson;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ExcelJsonConverter {
    ObjectMapper mapper = new ObjectMapper();
    public static final String TYPE_CLASS = "Class";

    public String convertToJson(ExcelSheet.Row header, ExcelSheet.Row row) throws ExceptionJson, ExceptionParseObject, ExceptionIO {
        try {
            ObjectNode childNode = this.getNode(header, row);
            return this.toString(childNode);
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    public String convertToJson(ExcelSheet dados) throws ExceptionJson, ExceptionParseObject, ExceptionIO {
        try {
            ExcelSheet.Row header = dados.getHeader();
            ObjectNode rootNode = this.mapper.createObjectNode();
            List<ExcelSheet.Row> rows = dados.getRowsExceptHead();
            LinkedList<ObjectNode> itens = new LinkedList<ObjectNode>();
            for (ExcelSheet.Row row : rows) {
                itens.add(this.getNode(header, row));
            }
            rootNode.arrayNode().addAll(itens);
            StringWriter sw = new StringWriter();
            this.mapper.writeValue((Writer)sw, itens);
            return this.toString(itens);
        }
        catch (JsonProcessingException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionJson(ex, new Object[0]);
        }
        catch (IOException ex) {
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    public ObjectNode getNode(ExcelSheet.Row header, ExcelSheet.Row data) throws ExceptionParseObject {
        ObjectNode childNode = this.mapper.createObjectNode();
        for (int i = 0; i <= header.getMaxCellIndex(); ++i) {
            ExcelSheet.Cell cellHeader = header.getCell(i);
            if (cellHeader == null) continue;
            ExcelSheet.Cell cell = data.getCell(i);
            this.writeIt(cellHeader, cell, childNode);
        }
        return childNode;
    }

    ObjectNode createElement(String headerName, ObjectNode parent) {
        return null;
    }

    public void writeIt(ExcelSheet.Cell cellHeader, ExcelSheet.Cell cell, ObjectNode childNode) throws ExceptionParseObject {
        String headerName = cellHeader.asString();
        if (cell == null) {
            childNode.put(headerName, "");
            return;
        }
        int index = headerName.indexOf(".");
        ObjectNode toSet = childNode;
        String name = headerName;
        while (index >= 0) {
            ObjectNode temp = (ObjectNode)toSet.get(name.substring(0, index));
            if (temp == null) {
                temp = this.mapper.createObjectNode();
                toSet.set(name.substring(0, index), (JsonNode)temp);
            }
            toSet = temp;
            name = name.substring(index + 1);
            index = name.indexOf(".");
        }
        switch (cell.getType()) {
            case BLANK: {
                toSet.put(name, (String)null);
                break;
            }
            case BOOLEAN: {
                toSet.put(name, cell.asShort());
                break;
            }
            case ERROR: {
                toSet.put(name, (String)null);
                break;
            }
            case FORMULA: {
                toSet.put(name, (String)null);
                break;
            }
            case STRING: {
                toSet.put(name, cell.asString());
                break;
            }
            case DATE: {
                toSet.put(name, cell.asLong());
                break;
            }
            case NUMERIC: {
                Double value = cell.asDouble();
                Double ceill = Math.ceil(value);
                if (ToolFormatter.arrredondarNumero(ceill - value, 10) != 0.0) {
                    toSet.put(name, value);
                    break;
                }
                toSet.put(name, value.longValue());
                break;
            }
            default: {
                throw new ExceptionErroProgramacao("Tipo do excel nao mapeado.");
            }
        }
    }

    private String toString(List<ObjectNode> itens) throws IOException {
        StringWriter sw = new StringWriter();
        this.mapper.writeValue((Writer)sw, itens);
        return sw.toString();
    }

    private String toString(ObjectNode item) throws IOException {
        StringWriter sw = new StringWriter();
        this.mapper.writeValue((Writer)sw, (Object)item);
        return sw.toString();
    }

    public ExcelSheet convertToExcel(String json) throws ExceptionIO {
        List<LinkedTreeMap> listData = ToolJson.readJsonAsLinkedMapList(json);
        ExcelSheet dados = new ExcelSheet();
        if (listData.isEmpty()) {
            return dados;
        }
        ExcelSheet.Row header = dados.newRow(0);
        LinkedTreeMap data = listData.get(0);
        Set keys = data.keySet();
        int i = 0;
        for (String keyStr : keys) {
            if (keyStr.endsWith(TYPE_CLASS)) continue;
            header.newCell(i).setString(keyStr);
            ++i;
        }
        int rowIndex = 1;
        for (LinkedTreeMap map : listData) {
            ExcelSheet.Row row = dados.newRow(rowIndex);
            int cellIndex = 0;
            for (String keyStr : keys) {
                if (keyStr.endsWith(TYPE_CLASS)) continue;
                ExcelSheet.Cell cell = row.newCell(cellIndex).setObject(map.get((Object)keyStr));
                Object type = map.get((Object)(keyStr + TYPE_CLASS));
                if (type != null && ExcelCellType.get(String.valueOf(type)) != null) {
                    cell.setType(ExcelCellType.get(String.valueOf(type)));
                }
                ++cellIndex;
            }
            ++rowIndex;
        }
        return dados;
    }
}

