/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.excel.model;

import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.impl.parse.ExceptionParseObject;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.excel.model.ExcelCellType;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;

public class ExcelSheet {
    private String name = "sheet";
    private List<Row> rows = new LinkedList<Row>();

    public int getRowsNumber() {
        return this.rows.size();
    }

    public List<Row> getRowsExceptHead() {
        if (this.getRows().size() <= 1) {
            return new LinkedList<Row>();
        }
        LinkedList<Row> ret = new LinkedList<Row>();
        ret.addAll(this.getRows());
        ret.remove(this.getHeader());
        return ret;
    }

    public Row newRow(int i) {
        Row r = new Row(i);
        this.getRows().add(r);
        this.orderRows();
        return r;
    }

    public Row newRow() {
        int localIndex = this.getMaxRowIndex();
        Row r = localIndex > 0 || localIndex == 0 && this.getRowsNumber() > 0 ? new Row(++localIndex) : new Row(0);
        this.getRows().add(r);
        this.orderRows();
        return r;
    }

    public int getMaxRowIndex() {
        Optional max = this.rows.stream().max((i1, i2) -> Integer.valueOf(i1.getIndex()).compareTo(i2.getIndex()));
        if (max.isPresent()) {
            return ((Row)max.get()).getIndex();
        }
        return 0;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public Row getHeader() {
        Optional<Row> found = this.getRows().stream().filter(i -> i.getIndex() == 0).findFirst();
        return found.isPresent() ? found.get() : null;
    }

    private void orderRows() {
        Collections.sort(this.rows);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelSheet)) {
            return false;
        }
        ExcelSheet other = (ExcelSheet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Row> this$rows = this.getRows();
        List<Row> other$rows = other.getRows();
        return !(this$rows == null ? other$rows != null : !((Object)this$rows).equals(other$rows));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExcelSheet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<Row> $rows = this.getRows();
        result = result * 59 + ($rows == null ? 43 : ((Object)$rows).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ExcelSheet(name=" + this.getName() + ", rows=" + String.valueOf(this.getRows()) + ")";
    }

    public static class Row
    implements Comparable<Row> {
        private int index = 0;
        private List<Cell> cells = new LinkedList<Cell>();

        public Row(int index) {
            if (index < 0) {
                throw new ExceptionRuntimeBase("E.GEN.000044");
            }
            this.index = index;
        }

        public void setIndex(int index) {
            if (index < 0) {
                throw new ExceptionRuntimeBase("E.GEN.000044");
            }
            this.index = index;
        }

        public int getCellsSize() {
            return this.cells.size();
        }

        public int getMaxCellIndex() {
            Optional max = this.cells.stream().max((i1, i2) -> Integer.valueOf(i1.getIndex()).compareTo(i2.getIndex()));
            if (max.isPresent()) {
                return ((Cell)max.get()).getIndex();
            }
            return 0;
        }

        public Cell getOrNewCell(int i) {
            Cell cell = this.getCell(i);
            if (cell == null) {
                cell = this.newCell(i);
            }
            return cell;
        }

        public Cell getCell(int i) {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return found.get();
            }
            return null;
        }

        public String getCellAsString(int i) {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return found.get().asString();
            }
            return null;
        }

        public Double getCellADouble(int i) throws ExceptionParseObject {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return found.get().asDouble();
            }
            return 0.0;
        }

        public Float getCellAsFloat(int i) throws ExceptionParseObject {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return Float.valueOf(found.get().asFloat());
            }
            return Float.valueOf(0.0f);
        }

        public Integer getCellAsInt(int i) throws ExceptionParseObject {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return found.get().asInt();
            }
            return 0;
        }

        public Long getCellAsLong(int i) throws ExceptionParseObject {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return found.get().asLong();
            }
            return 0L;
        }

        public Short getCellAsShort(int i) throws ExceptionParseObject {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return found.get().asShort();
            }
            return (short)0;
        }

        public Date getCellAsDate(int i) throws ExceptionParseObject {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return found.get().asDate();
            }
            return null;
        }

        public Date getCellAsDate(int i, String mask) throws ExceptionParseObject {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return found.get().asDate(mask);
            }
            return null;
        }

        public Object getObject(int i, String mask) throws ExceptionParseObject {
            this.orderCells();
            Optional<Cell> found = this.cells.stream().filter(j -> j.index == i).findFirst();
            if (found.isPresent()) {
                return found.get().asValue(mask);
            }
            return null;
        }

        public Cell newCell(int i) {
            Cell c = new Cell(i);
            this.cells.add(c);
            this.orderCells();
            return c;
        }

        public Cell newCell() {
            int localIndex = this.getMaxCellIndex();
            Cell c = localIndex > 0 || localIndex == 0 && this.getCellsSize() > 0 ? new Cell(++localIndex) : new Cell(0);
            this.cells.add(c);
            this.orderCells();
            return c;
        }

        public List<Cell> getCells() {
            this.orderCells();
            return this.cells;
        }

        public String toString() {
            return String.valueOf(this.getIndex());
        }

        @Override
        public int compareTo(Row o) {
            return Integer.valueOf(this.index).compareTo(o.getIndex());
        }

        private void orderCells() {
            Collections.sort(this.cells);
        }

        public boolean isCellsEmpty() {
            return this.cells.isEmpty();
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public void setCells(List<Cell> cells) {
            this.cells = cells;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            List<Cell> this$cells = this.getCells();
            List<Cell> other$cells = other.getCells();
            return !(this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Row;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            List<Cell> $cells = this.getCells();
            result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
            return result;
        }
    }

    public static class Cell
    implements Comparable<Cell> {
        private int index = 0;
        private String data;
        private ExcelCellType type;

        public Cell(int index) {
            if (index < 0) {
                throw new ExceptionRuntimeBase("E.GEN.000044");
            }
            this.index = index;
        }

        public void setIndex(int index) {
            if (index < 0) {
                throw new ExceptionRuntimeBase("E.GEN.000044");
            }
            this.index = index;
        }

        public double asDouble() throws ExceptionParseObject {
            try {
                if (!ToolMethods.isStrWithData(this.data)) {
                    return 0.0;
                }
                return NumberFormat.getNumberInstance().parse(this.data).doubleValue();
            }
            catch (ParseException ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw new ExceptionParseObject(ex, new Object[]{ex.getMessage()});
            }
        }

        public double asDoubleWrite() throws ExceptionParseObject {
            try {
                if (!ToolMethods.isStrWithData(this.data)) {
                    return 0.0;
                }
                return NumberFormat.getNumberInstance(Locale.US).parse(this.data).doubleValue();
            }
            catch (ParseException ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw new ExceptionParseObject(ex, new Object[]{ex.getMessage()});
            }
        }

        public float asFloat() throws ExceptionParseObject {
            try {
                if (!ToolMethods.isStrWithData(this.data)) {
                    return 0.0f;
                }
                return NumberFormat.getNumberInstance(Locale.US).parse(this.data).floatValue();
            }
            catch (ParseException ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw new ExceptionParseObject(ex, new Object[]{ex.getMessage()});
            }
        }

        public short asShort() throws ExceptionParseObject {
            try {
                if (!ToolMethods.isStrWithData(this.data)) {
                    return 0;
                }
                return NumberFormat.getNumberInstance().parse(this.data).shortValue();
            }
            catch (ParseException ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw new ExceptionParseObject(ex, new Object[]{ex.getMessage()});
            }
        }

        public int asInt() throws ExceptionParseObject {
            try {
                if (!ToolMethods.isStrWithData(this.data)) {
                    return 0;
                }
                return NumberFormat.getNumberInstance().parse(this.data).intValue();
            }
            catch (ParseException ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw new ExceptionParseObject(ex, new Object[]{ex.getMessage()});
            }
        }

        public long asLong() throws ExceptionParseObject {
            try {
                if (!ToolMethods.isStrWithData(this.data)) {
                    return 0L;
                }
                return NumberFormat.getNumberInstance().parse(this.data).longValue();
            }
            catch (ParseException ex) {
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw new ExceptionParseObject(ex, new Object[]{ex.getMessage()});
            }
        }

        public Date asDate() {
            return new Date(Long.parseLong(this.data));
        }

        public Cell setString(String data) {
            this.data = data;
            this.type = ExcelCellType.STRING;
            return this;
        }

        public Cell setNumeric(Double data) {
            this.data = String.valueOf(data);
            this.type = ExcelCellType.NUMERIC;
            return this;
        }

        public Cell setNumeric(Float data) {
            this.data = String.valueOf(data);
            this.type = ExcelCellType.NUMERIC;
            return this;
        }

        public Cell setNumeric(Integer data) {
            this.data = String.valueOf(data);
            this.type = ExcelCellType.NUMERIC;
            return this;
        }

        public Cell setNumeric(Short data) {
            this.data = String.valueOf(data);
            this.type = ExcelCellType.NUMERIC;
            return this;
        }

        public Cell setNumeric(Long data) {
            this.data = String.valueOf(data);
            this.type = ExcelCellType.NUMERIC;
            return this;
        }

        public Cell setNumeric(Date data) {
            return this.setDate(data);
        }

        public Cell setDate(Date data) {
            this.data = String.valueOf(data.getTime());
            this.type = ExcelCellType.DATE;
            return this;
        }

        public Cell setObject(Object value) {
            if (value == null) {
                this.data = null;
                this.type = ExcelCellType.BLANK;
                return this;
            }
            if (value instanceof Date) {
                this.setDate((Date)value);
                return this;
            }
            if (value instanceof Double) {
                this.setNumeric((Double)value);
                return this;
            }
            if (value instanceof Float) {
                this.setNumeric((Float)value);
                return this;
            }
            if (value instanceof Integer) {
                this.setNumeric((Integer)value);
                return this;
            }
            if (value instanceof Short) {
                this.setNumeric((Short)value);
                return this;
            }
            if (value instanceof Long) {
                this.setNumeric((Long)value);
                return this;
            }
            this.setString(String.valueOf(value));
            return this;
        }

        public String asString() {
            return this.data;
        }

        public Date asDate(String mask) {
            return ToolDate.strToDate(this.data, mask);
        }

        public Object asValue(String mask) throws ExceptionParseObject {
            switch (this.type) {
                case BLANK: {
                    return null;
                }
                case ERROR: {
                    return null;
                }
                case NUMERIC: {
                    return this.asDouble();
                }
                case DATE: {
                    return this.asDate();
                }
                case BOOLEAN: {
                    return this.asShort();
                }
                case FORMULA: {
                    return null;
                }
                case STRING: {
                    return this.asString();
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            return String.valueOf(this.getIndex() + ": " + this.getData());
        }

        @Override
        public int compareTo(Cell o) {
            return Integer.valueOf(this.index).compareTo(o.getIndex());
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public ExcelCellType getType() {
            return this.type;
        }

        @Generated
        public void setData(String data) {
            this.data = data;
        }

        @Generated
        public void setType(ExcelCellType type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cell)) {
                return false;
            }
            Cell other = (Cell)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            ExcelCellType this$type = this.getType();
            ExcelCellType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cell;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            ExcelCellType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }
    }
}

