/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementortools.tools.file;

import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.web.multipart.MultipartFile;

public class ToolFile {
    public static String ZIP_FILE_EXT_DOT = ".zip";
    public static String XML_FILE_EXT_DOT = ".xml";
    public static String TXT_FILE_EXT_DOT = ".txt";
    public static String PDF_FILE_EXT_DOT = ".pdf";
    public static String HTML_FILE_EXT_DOT = ".html";
    public static String ZIP_FILE_EXT = "zip";
    public static String XML_FILE_EXT = "xml";
    public static String TXT_FILE_EXT = "txt";
    public static String PDF_FILE_EXT = "pdf";
    public static String HTML_FILE_EXT = "html";

    public static String getFileNameWithoutExt(String fileName) {
        String name = fileName;
        if (fileName.lastIndexOf(".") >= 0) {
            name = fileName.substring(0, fileName.lastIndexOf("."));
        }
        return name;
    }

    public static File writeStringInFile(String file, StringBuffer st) throws ExceptionIO {
        return ToolFile.writeStringInFile(new File(file), st.toString());
    }

    public static File writeStringInFile(String file, String st) throws ExceptionIO {
        return ToolFile.writeStringInFile(new File(file), st);
    }

    public static File writeStringInFile(File f, String st) throws ExceptionIO {
        try (PrintWriter pt = null;){
            if (f.getParentFile() != null && !f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            if (!f.exists()) {
                f.createNewFile();
            }
            pt = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8));
            pt.write(st);
            pt.flush();
            pt.close();
            File file = f;
            return file;
        }
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static File getUserDirFile() {
        return new File(ToolFile.getUserDir());
    }

    public static String getTMPDir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getFileTMPDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static File createTempFile(String nomeArquivo, String extensao) {
        String dir = System.getProperty("java.io.tmpdir");
        if (!nomeArquivo.endsWith(".") && ((String)extensao).endsWith(".")) {
            extensao = "." + (String)extensao;
        }
        File f = new File(dir + File.separator + nomeArquivo + "_" + new Date().getTime() + "_" + (String)extensao);
        return f;
    }

    public static File createTempFile(String nomeArquivo) {
        String dir = System.getProperty("java.io.tmpdir");
        File f = new File(dir + File.separator + nomeArquivo);
        return f;
    }

    public static byte[] getBytesFromFile(File temp) throws ExceptionIO {
        FileInputStream finp = null;
        try {
            finp = new FileInputStream(temp);
            byte[] byArray = IOUtils.toByteArray((InputStream)finp);
            return byArray;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{temp.getAbsolutePath()});
        }
        finally {
            try {
                if (finp != null) {
                    finp.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] getBytesFromFile(InputStream temp) throws ExceptionIO {
        try {
            return IOUtils.toByteArray((InputStream)temp);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public static void writeBytesOnFile(File temp, byte[] arquivoKeystore) throws ExceptionIO {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(temp);
            fout.write(arquivoKeystore);
            fout.flush();
            fout.close();
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getFileName(String nomeArquivo, String ext) {
        if ((nomeArquivo = ToolString.refina(nomeArquivo)).endsWith(ext)) {
            return nomeArquivo;
        }
        return nomeArquivo + "." + ext;
    }

    public static File getFileName(File arquivo, String ext) {
        String nomeArquivo = arquivo.getName();
        if (nomeArquivo.endsWith(ext)) {
            return arquivo;
        }
        return new File(arquivo.getParentFile().getAbsolutePath() + File.separator + nomeArquivo + "." + ext);
    }

    public static File renameFileName(File ger, String nomeArquivo, boolean keepExtension) {
        File out;
        boolean res;
        int index;
        Object aux = nomeArquivo;
        if (keepExtension && (index = ger.getName().lastIndexOf(".")) > 0) {
            aux = nomeArquivo + ger.getName().substring(index);
        }
        if (res = ger.renameTo(out = new File(ger.getParentFile().getAbsolutePath() + File.separator + (String)aux))) {
            return out;
        }
        return ger;
    }

    public static String getConteudoArquivo(String path) throws ExceptionIO {
        return ToolFile.getConteudoArquivo(new File(path));
    }

    public static String getConteudoArquivo(InputStream inp, String charset) throws ExceptionIO {
        String result = "";
        try {
            result = IOUtils.toString((InputStream)inp, (String)charset);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionIO(e, new Object[]{e.getMessage()});
        }
        return result;
    }

    public static String getConteudoArquivo(InputStream inp) throws ExceptionIO {
        return ToolFile.getConteudoArquivo(inp, StandardCharsets.ISO_8859_1.name());
    }

    public static String getConteudoArquivo(File f) throws ExceptionIO {
        try {
            return ToolFile.getConteudoArquivo(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ExceptionIO((IOException)e, new Object[]{e.getMessage()});
        }
    }

    public static void writeInFile(InputStream xsd, File temp) throws ExceptionIO {
        try (FileOutputStream out = new FileOutputStream(temp);){
            IOUtils.copy((InputStream)xsd, (OutputStream)out);
            xsd.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionIO(e, new Object[]{e.getMessage()});
        }
    }

    public static void moveRenameFile(File in, File outFile) throws ExceptionIO {
        try {
            FileInputStream tempIn = new FileInputStream(in);
            try (FileOutputStream out = new FileOutputStream(outFile);){
                IOUtils.copy((InputStream)tempIn, (OutputStream)out);
                out.close();
                tempIn.close();
                in.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExceptionIO(e, new Object[]{e.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File f, File newDest) throws ExceptionIO {
        OutputStream fout = null;
        try {
            newDest.getParentFile().mkdirs();
            Files.copy(f.toPath(), newDest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            try {
                throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                try {
                    if (fout == null) throw throwable;
                    fout.flush();
                    ((FileOutputStream)fout).close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    throw new ExceptionIO(ex2, new Object[]{ex2.getMessage()});
                }
            }
        }
        try {
            if (fout == null) return;
            fout.flush();
            ((FileOutputStream)fout).close();
            return;
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public static void copyFolder(File source, File destination) throws ExceptionIO {
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if (source.isDirectory()) {
            for (File f : source.listFiles()) {
                if (f.isDirectory()) {
                    String folderName = f.getName();
                    File temp = destination;
                    if (!f.getName().equals(destination.getName())) {
                        temp = new File(destination.getAbsolutePath() + File.separator + folderName);
                    }
                    ToolFile.copyFolder(f, temp);
                    continue;
                }
                File temp = new File(destination.getAbsolutePath() + File.separator + f.getName());
                ToolFile.copyFile(f, temp);
            }
        } else {
            ToolFile.copyFile(source, destination);
        }
    }

    public static void copyFile(InputStream in, OutputStream out) throws ExceptionIO {
        ToolFile.copyFile(in, out, null);
    }

    public static void copyFile(InputStream input, OutputStream output, CopyProgress copyProgress) throws ExceptionIO {
        try {
            ToolFile.copyFile(input, output, input.available(), copyProgress);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
    }

    public static void copyFile(InputStream input, OutputStream output, int availableLength, CopyProgress copyProgress) throws ExceptionIO {
        try {
            int bytesRead;
            byte[] buffer = new byte[4096];
            long totalBytes = availableLength;
            if (copyProgress != null) {
                copyProgress.copyStarted();
            }
            long totalBytesRead = 0L;
            while (-1 != (bytesRead = input.read(buffer))) {
                output.write(buffer, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
                if (totalBytes <= 0L) continue;
                double progress = (double)totalBytesRead * 100.0 / (double)totalBytes;
                if (copyProgress == null) continue;
                copyProgress.copyProgress(progress);
            }
            input.close();
            output.flush();
            output.close();
            if (copyProgress != null) {
                copyProgress.copyFinished();
            }
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{ex.getMessage()});
        }
    }

    public static String md5(File f) throws ExceptionIO {
        try {
            return DigestUtils.md5Hex((InputStream)new FileInputStream(f));
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{f.getAbsolutePath()});
        }
    }

    public static void removeFiles(File fileOrFolder, boolean ignoreCase, String ... filesNotToDelete) {
        if (!fileOrFolder.exists()) {
            return;
        }
        if (ToolMethods.containsInArray(filesNotToDelete, fileOrFolder.getName(), ignoreCase)) {
            return;
        }
        File[] children = fileOrFolder.listFiles();
        if (children != null) {
            for (File f : children) {
                ToolFile.removeFiles(f, ignoreCase, filesNotToDelete);
            }
        }
        fileOrFolder.delete();
    }

    public static void removeFiles(File fileOrFolder) {
        ToolFile.removeFiles(fileOrFolder, false, new String[0]);
    }

    public static List<String> getFilesLines(InputStream inputStream) throws ExceptionIO {
        LinkedList<String> lines = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new ExceptionIO(e, new Object[]{e.getMessage()});
        }
        return lines;
    }

    public static String getExtFileWithDot(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            return fileName.substring(index);
        }
        return "";
    }

    public static String getExtFileWithoutDot(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    public static String getExtFileWithDot(File file) {
        return ToolFile.getExtFileWithDot(file.getName());
    }

    public static String getExtFileWithoutDot(File file) {
        return ToolFile.getExtFileWithoutDot(file.getName());
    }

    public static String getValidFileName(String filename) {
        String sane = filename.replaceAll("[^a-zA-Z0-9\\._]+", "_");
        return sane;
    }

    public static boolean isFile(String fileExtension, File arquivo) {
        if (arquivo == null || fileExtension == null) {
            return false;
        }
        return arquivo.getName().toLowerCase().endsWith(fileExtension.toLowerCase());
    }

    public static Collection<? extends File> getFiles(String fileExtension, File dir) {
        LinkedList<? extends File> files = new LinkedList<File>();
        if (dir == null || fileExtension == null) {
            return files;
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                files.addAll(ToolFile.getFiles(fileExtension, f));
                continue;
            }
            if (!ToolFile.isFile(fileExtension, f)) continue;
            files.add(f);
        }
        return files;
    }

    public static File createTempDir(String dirName) {
        File tempDir = ToolFile.getFileTMPDir();
        tempDir = new File(tempDir.getAbsolutePath() + File.separator + dirName);
        tempDir.mkdirs();
        return tempDir;
    }

    public static File createTempDir(String dirName, boolean deleteChildrenFilesIfExists) throws ExceptionInvalidState {
        File tempDir = ToolFile.createTempDir(dirName);
        for (File l : tempDir.listFiles()) {
            boolean del = l.delete();
            if (del) continue;
            throw new ExceptionInvalidState("", new Object[]{l.getAbsolutePath()});
        }
        return tempDir;
    }

    public static File createAndWrite(String fileName, String ext, byte[] data) throws ExceptionIO {
        File temp = ToolFile.createTempFile(fileName, ext);
        ToolFile.writeBytesOnFile(temp, data);
        return temp;
    }

    public static File createAndWrite(String fileName, byte[] data) throws ExceptionIO {
        File temp = ToolFile.createTempFile(fileName);
        ToolFile.writeBytesOnFile(temp, data);
        return temp;
    }

    public static File createAndWrite(String fileName, String ext, String data) throws ExceptionIO {
        File temp = ToolFile.createTempFile(fileName, ext);
        ToolFile.writeStringInFile(temp, data);
        return temp;
    }

    public static File createAndWrite(String fileName, String data) throws ExceptionIO {
        File temp = ToolFile.createTempFile(fileName);
        ToolFile.writeStringInFile(temp, data);
        return temp;
    }

    public static File toFile(MultipartFile multipartFile) throws ExceptionIO, FileNotFoundException, IOException {
        File file = ToolFile.createTempFile("temp_" + String.valueOf(new Date().getTime()));
        try (FileOutputStream os = new FileOutputStream(file);){
            ((OutputStream)os).write(multipartFile.getBytes());
        }
        return file;
    }

    public static void deleteWithException(File dir) throws ExceptionIO {
        if (dir == null) {
            return;
        }
        try {
            Files.deleteIfExists(dir.toPath());
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex, new Object[]{dir});
        }
    }

    public static boolean delete(File dir) {
        if (dir == null) {
            return true;
        }
        try {
            Files.deleteIfExists(dir.toPath());
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static interface CopyProgress {
        public void copyStarted();

        public void copyProgress(Double var1);

        public void copyFinished();
    }
}

